/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.registry;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.RegistryClientIDResult;
import org.apache.nifi.web.api.dto.RegistryDTO;
import org.apache.nifi.web.api.entity.RegistryClientsEntity;

public class GetRegistryClientId
extends AbstractNiFiCommand<RegistryClientIDResult> {
    public GetRegistryClientId() {
        super("get-reg-client-id", RegistryClientIDResult.class);
    }

    @Override
    public String getDescription() {
        return "Returns the id of the first registry client found with the given name or url. Only one of name or url can be specified.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.REGISTRY_CLIENT_NAME.createOption());
        this.addOption(CommandOption.REGISTRY_CLIENT_URL.createOption());
    }

    @Override
    public RegistryClientIDResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, CommandException {
        String regClientName = this.getArg(properties, CommandOption.REGISTRY_CLIENT_NAME);
        String regClientUrl = this.getArg(properties, CommandOption.REGISTRY_CLIENT_URL);
        if (!StringUtils.isBlank((CharSequence)regClientName) && !StringUtils.isBlank((CharSequence)regClientUrl)) {
            throw new CommandException("Name and URL cannot be specified at the same time");
        }
        if (StringUtils.isBlank((CharSequence)regClientName) && StringUtils.isBlank((CharSequence)regClientUrl)) {
            throw new CommandException("Name or URL must be specified");
        }
        RegistryClientsEntity registries = client.getControllerClient().getRegistryClients();
        RegistryDTO registry = !StringUtils.isBlank((CharSequence)regClientName) ? (RegistryDTO)registries.getRegistries().stream().map(r -> r.getComponent()).filter(r -> r.getName().equalsIgnoreCase(regClientName.trim())).findFirst().orElse(null) : (RegistryDTO)registries.getRegistries().stream().map(r -> r.getComponent()).filter(r -> r.getUri().equalsIgnoreCase(regClientUrl.trim())).findFirst().orElse(null);
        if (registry == null) {
            throw new NiFiClientException("No registry client exists with the name '" + regClientName + "'");
        }
        return new RegistryClientIDResult(this.getResultType(properties), registry);
    }
}

