/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.params;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.Result;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ParamContextClient;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.web.api.entity.ParameterContextEntity;
import org.apache.nifi.web.api.entity.ParameterContextUpdateRequestEntity;

public abstract class AbstractUpdateParamContextCommand<R extends Result>
extends AbstractNiFiCommand<R> {
    public AbstractUpdateParamContextCommand(String name, Class<R> resultClass) {
        super(name, resultClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ParameterContextUpdateRequestEntity performUpdate(ParamContextClient client, ParameterContextEntity parameterContextEntity, ParameterContextUpdateRequestEntity updateRequestEntity) throws NiFiClientException, IOException {
        AtomicBoolean cancelled = new AtomicBoolean(false);
        String contextId = parameterContextEntity.getId();
        String updateRequestId = updateRequestEntity.getRequest().getRequestId();
        try {
            boolean completed = false;
            for (int i = 0; i < 30; ++i) {
                ParameterContextUpdateRequestEntity retrievedUpdateRequest = client.getParamContextUpdateRequest(contextId, updateRequestId);
                if (retrievedUpdateRequest != null && retrievedUpdateRequest.getRequest().isComplete()) {
                    completed = true;
                    break;
                }
                try {
                    if (this.getContext().isInteractive()) {
                        this.println("Waiting for update request to complete...");
                    }
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (!completed) {
                cancelled.set(true);
            }
        }
        finally {
            ParameterContextUpdateRequestEntity deleteUpdateRequest = client.deleteParamContextUpdateRequest(contextId, updateRequestId);
            String failureReason = deleteUpdateRequest.getRequest().getFailureReason();
            if (!StringUtils.isBlank((CharSequence)failureReason)) {
                throw new NiFiClientException(failureReason);
            }
            if (cancelled.get()) {
                throw new NiFiClientException("Unable to update parameter context, cancelling update request");
            }
            return deleteUpdateRequest;
        }
    }
}

