/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ReportingTasksClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.AbstractJerseyClient;
import org.apache.nifi.web.api.entity.ReportingTaskEntity;
import org.apache.nifi.web.api.entity.ReportingTaskRunStatusEntity;

public class JerseyReportingTasksClient
extends AbstractJerseyClient
implements ReportingTasksClient {
    private final WebTarget reportingTasksTarget;

    public JerseyReportingTasksClient(WebTarget baseTarget) {
        this(baseTarget, Collections.emptyMap());
    }

    public JerseyReportingTasksClient(WebTarget baseTarget, Map<String, String> headers) {
        super(headers);
        this.reportingTasksTarget = baseTarget.path("/reporting-tasks");
    }

    @Override
    public ReportingTaskEntity getReportingTask(String id) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Reporting task id cannot be null");
        }
        return this.executeAction("Error retrieving status of reporting task", () -> {
            WebTarget target = this.reportingTasksTarget.path(id);
            return (ReportingTaskEntity)this.getRequestBuilder(target).get(ReportingTaskEntity.class);
        });
    }

    @Override
    public ReportingTaskEntity activateReportingTask(String id, ReportingTaskRunStatusEntity runStatusEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Reporting task id cannot be null");
        }
        if (runStatusEntity == null) {
            throw new IllegalArgumentException("Entity cannnot be null");
        }
        return this.executeAction("Error starting or stopping report task", () -> {
            WebTarget target = this.reportingTasksTarget.path("{id}/run-status").resolveTemplate("id", (Object)id);
            return (ReportingTaskEntity)this.getRequestBuilder(target).put(Entity.entity((Object)runStatusEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ReportingTaskEntity.class);
        });
    }
}

