/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.client.WebTarget;
import org.apache.nifi.toolkit.cli.impl.client.nifi.InputPortClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.CRUDJerseyClient;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.entity.PortEntity;

public class JerseyInputPortClient
extends CRUDJerseyClient<PortEntity>
implements InputPortClient {
    public JerseyInputPortClient(WebTarget baseTarget) {
        this(baseTarget, Collections.emptyMap());
    }

    public JerseyInputPortClient(WebTarget baseTarget, Map<String, String> headers) {
        super(baseTarget.path("/process-groups/{pgId}/input-ports"), baseTarget.path("/input-ports/{id}"), headers, PortEntity.class, "Input Port");
    }

    @Override
    public PortEntity createInputPort(String parentGroupId, PortEntity entity) throws NiFiClientException, IOException {
        return this.createComponent(parentGroupId, entity);
    }

    @Override
    public PortEntity getInputPort(String id) throws NiFiClientException, IOException {
        return (PortEntity)this.getComponent(id);
    }

    @Override
    public PortEntity updateInputPort(PortEntity entity) throws NiFiClientException, IOException {
        return this.updateComponent(entity);
    }

    @Override
    public PortEntity deleteInputPort(PortEntity entity) throws NiFiClientException, IOException {
        return this.deleteComponent(entity);
    }

    @Override
    public PortEntity startInputPort(PortEntity entity) throws NiFiClientException, IOException {
        PortEntity startEntity = this.createStateEntity(entity, "RUNNING");
        return this.updateInputPort(startEntity);
    }

    @Override
    public PortEntity stopInputPort(PortEntity entity) throws NiFiClientException, IOException {
        PortEntity startEntity = this.createStateEntity(entity, "STOPPED");
        return this.updateInputPort(startEntity);
    }

    private PortEntity createStateEntity(PortEntity entity, String state) {
        PortDTO component = new PortDTO();
        component.setId(entity.getComponent().getId());
        component.setParentGroupId(entity.getComponent().getParentGroupId());
        component.setState(state);
        PortEntity stateEntity = new PortEntity();
        stateEntity.setId(entity.getId());
        stateEntity.setRevision(entity.getRevision());
        stateEntity.setComponent(component);
        return stateEntity;
    }
}

