/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ControllerServicesClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.AbstractJerseyClient;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.ControllerServiceReferencingComponentsEntity;
import org.apache.nifi.web.api.entity.ControllerServiceRunStatusEntity;
import org.apache.nifi.web.api.entity.UpdateControllerServiceReferenceRequestEntity;

public class JerseyControllerServicesClient
extends AbstractJerseyClient
implements ControllerServicesClient {
    private final WebTarget controllerServicesTarget;
    private final WebTarget processGroupTarget;

    public JerseyControllerServicesClient(WebTarget baseTarget) {
        this(baseTarget, Collections.emptyMap());
    }

    public JerseyControllerServicesClient(WebTarget baseTarget, Map<String, String> headers) {
        super(headers);
        this.controllerServicesTarget = baseTarget.path("/controller-services");
        this.processGroupTarget = baseTarget.path("/process-groups/{pgId}");
    }

    @Override
    public ControllerServiceEntity getControllerService(String id) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Controller service id cannot be null");
        }
        return this.executeAction("Error retrieving status of controller service", () -> {
            WebTarget target = this.controllerServicesTarget.path("{id}").resolveTemplate("id", (Object)id);
            return (ControllerServiceEntity)this.getRequestBuilder(target).get(ControllerServiceEntity.class);
        });
    }

    @Override
    public ControllerServiceEntity activateControllerService(String id, ControllerServiceRunStatusEntity runStatusEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Controller service id cannot be null");
        }
        if (runStatusEntity == null) {
            throw new IllegalArgumentException("Entity cannnot be null");
        }
        return this.executeAction("Error enabling or disabling controller service", () -> {
            WebTarget target = this.controllerServicesTarget.path("{id}/run-status").resolveTemplate("id", (Object)id);
            return (ControllerServiceEntity)this.getRequestBuilder(target).put(Entity.entity((Object)runStatusEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ControllerServiceEntity.class);
        });
    }

    @Override
    public ControllerServiceEntity createControllerService(String parentGroupdId, ControllerServiceEntity controllerServiceEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)parentGroupdId)) {
            throw new IllegalArgumentException("Parent process group id cannot be null or blank");
        }
        if (controllerServiceEntity == null) {
            throw new IllegalArgumentException("Controller Service entity cannot be null");
        }
        return this.executeAction("Error creating Controller Service", () -> {
            WebTarget target = this.processGroupTarget.path("/controller-services").resolveTemplate("pgId", (Object)parentGroupdId);
            return (ControllerServiceEntity)this.getRequestBuilder(target).post(Entity.entity((Object)controllerServiceEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ControllerServiceEntity.class);
        });
    }

    @Override
    public ControllerServiceEntity updateControllerService(ControllerServiceEntity controllerServiceEntity) throws NiFiClientException, IOException {
        if (controllerServiceEntity == null) {
            throw new IllegalArgumentException("Controller Service entity cannot be null");
        }
        return this.executeAction("Error updating Controller Service", () -> {
            WebTarget target = this.controllerServicesTarget.path("/{id}").resolveTemplate("id", (Object)controllerServiceEntity.getId());
            return (ControllerServiceEntity)this.getRequestBuilder(target).put(Entity.entity((Object)controllerServiceEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ControllerServiceEntity.class);
        });
    }

    @Override
    public ControllerServiceEntity deleteControllerService(ControllerServiceEntity controllerServiceEntity) throws NiFiClientException, IOException {
        if (controllerServiceEntity == null) {
            throw new IllegalArgumentException("Controller Service entity cannot be null");
        }
        RevisionDTO revision = controllerServiceEntity.getRevision();
        if (revision == null) {
            throw new IllegalArgumentException("Controller Service Revision cannot be null");
        }
        return this.executeAction("Error deleting Controller Service", () -> {
            WebTarget target = this.controllerServicesTarget.path("/{id}").queryParam("version", new Object[]{revision.getVersion()}).queryParam("clientId", new Object[]{revision.getClientId()}).resolveTemplate("id", (Object)controllerServiceEntity.getId());
            return (ControllerServiceEntity)this.getRequestBuilder(target).delete(ControllerServiceEntity.class);
        });
    }

    @Override
    public ControllerServiceReferencingComponentsEntity getControllerServiceReferences(String id) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Controller service id cannot be null");
        }
        return this.executeAction("Error retrieving Controller Service's referencing components", () -> {
            WebTarget target = this.controllerServicesTarget.path("{id}/references").resolveTemplate("id", (Object)id);
            return (ControllerServiceReferencingComponentsEntity)this.getRequestBuilder(target).get(ControllerServiceReferencingComponentsEntity.class);
        });
    }

    @Override
    public ControllerServiceReferencingComponentsEntity updateControllerServiceReferences(UpdateControllerServiceReferenceRequestEntity referencesEntity) throws NiFiClientException, IOException {
        if (referencesEntity == null) {
            throw new IllegalArgumentException("Controller Service references entity cannot be null");
        }
        return this.executeAction("Error updating Controller Service references", () -> {
            WebTarget target = this.controllerServicesTarget.path("/{id}/references").resolveTemplate("id", (Object)referencesEntity.getId());
            return (ControllerServiceReferencingComponentsEntity)this.getRequestBuilder(target).put(Entity.entity((Object)referencesEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ControllerServiceReferencingComponentsEntity.class);
        });
    }
}

