/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.cs.tests.system.CountService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.AbstractReportingTask;
import org.apache.nifi.reporting.ReportingContext;

public class WriteToFileReportingTask
extends AbstractReportingTask {
    static final PropertyDescriptor FILENAME = new PropertyDescriptor.Builder().name("Filename").displayName("Filename").description("The File to write to").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    static final PropertyDescriptor TEXT = new PropertyDescriptor.Builder().name("Text").displayName("Text").description("The Text to Write").required(false).addValidator(Validator.VALID).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    static final PropertyDescriptor COUNT_SERVICE = new PropertyDescriptor.Builder().name("Count Service").displayName("Count Service").description("The Count Service to Use").required(false).identifiesControllerService(CountService.class).build();

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        if (validationContext.getProperty(COUNT_SERVICE).isSet() && validationContext.getProperty(TEXT).isSet()) {
            return Collections.singleton(new ValidationResult.Builder().subject("Count Service and Text").valid(false).explanation("Cannot set both the Text property and the Count Service property").build());
        }
        if (!validationContext.getProperty(COUNT_SERVICE).isSet() && !validationContext.getProperty(TEXT).isSet()) {
            return Collections.singleton(new ValidationResult.Builder().subject("Count Service and Text").valid(false).explanation("Either the Text property or the Count Service property must be set").build());
        }
        return Collections.emptyList();
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Arrays.asList(FILENAME, TEXT, COUNT_SERVICE);
    }

    public void onTrigger(ReportingContext context) {
        File outFile = new File(context.getProperty(FILENAME).evaluateAttributeExpressions().getValue());
        File parentFile = outFile.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            this.getLogger().error("Could not create directory {}", new Object[]{parentFile.getAbsolutePath()});
            return;
        }
        String text = context.getProperty(TEXT).evaluateAttributeExpressions().getValue();
        if (text == null) {
            CountService countService = (CountService)context.getProperty(COUNT_SERVICE).asControllerService(CountService.class);
            long count = countService.count();
            text = String.valueOf(count);
        }
        try (FileOutputStream fos = new FileOutputStream(outFile);){
            fos.write(text.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new ProcessException((Throwable)e);
        }
        this.getLogger().info("Wrote text to file {}", new Object[]{outFile.getAbsolutePath()});
    }
}

