/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.stream.io.StreamUtils;

public class WriteToFile
extends AbstractProcessor {
    static final PropertyDescriptor FILENAME = new PropertyDescriptor.Builder().name("Filename").displayName("Filename").description("The file to write the FlowFile contents to").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue("target/WriteToFile.out").build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").build();

    public Set<Relationship> getRelationships() {
        return new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE));
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Collections.singletonList(FILENAME);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String filename = context.getProperty(FILENAME).evaluateAttributeExpressions(flowFile).getValue();
        File file = new File(filename);
        File dir = file.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            this.getLogger().error("Could not write FlowFile to {} because the directory does not exist and could not be created", new Object[]{file.getAbsolutePath()});
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        try (FileOutputStream out = new FileOutputStream(file);
             InputStream in = session.read(flowFile);){
            StreamUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (Exception e) {
            this.getLogger().error("Could not write FlowFile to {}", new Object[]{file.getAbsolutePath(), e});
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        session.transfer(flowFile, REL_SUCCESS);
        this.getLogger().info("Wrote one FlowFile of size {} to {}", new Object[]{flowFile.getSize(), file.getAbsolutePath()});
        session.getProvenanceReporter().send(flowFile, file.toURI().toString());
    }
}

