/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.util.Collections;
import java.util.List;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;

public class ValidateFileExists
extends AbstractProcessor {
    static final PropertyDescriptor FILE = new PropertyDescriptor.Builder().name("Filename").displayName("Filename").description("A file that should exist").required(true).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[]{ResourceType.DIRECTORY}).build();
    private static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Collections.singletonList(FILE);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        session.adjustCounter("Triggered", 1L, true);
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        session.transfer(flowFile, REL_SUCCESS);
    }
}

