/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.util.Set;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.metrics.CommitTiming;

public class UpdateMetric
extends AbstractProcessor {
    private static final Relationship SUCCESS = new Relationship.Builder().name("success").autoTerminateDefault(true).build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(SUCCESS);

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        session.adjustCounter("onTrigger", 1L, true);
        Runtime runtime = Runtime.getRuntime();
        long freeMemory = runtime.freeMemory();
        session.recordGauge("freeMemory", (double)freeMemory, CommitTiming.NOW);
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        session.transfer(flowFile, SUCCESS);
    }
}

