/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractSessionFactoryProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
public class HoldInput
extends AbstractSessionFactoryProcessor {
    static final PropertyDescriptor IGNORE_TIME = new PropertyDescriptor.Builder().name("Hold Time").description("The amount of time to hold input FlowFiles without releasing them").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("3 sec").build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles go to this Relationship").build();
    private volatile long lastTransferTime;
    private final Set<FlowFileSession> flowFileSessions = Collections.synchronizedSet(new HashSet());

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return List.of(IGNORE_TIME);
    }

    public Set<Relationship> getRelationships() {
        return Set.of(REL_SUCCESS);
    }

    @OnScheduled
    public void reset() {
        this.lastTransferTime = System.nanoTime();
    }

    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        ProcessSession session = sessionFactory.createSession();
        List flowFiles = session.get(10000);
        if (flowFiles.isEmpty()) {
            return;
        }
        this.flowFileSessions.add(new FlowFileSession(session, flowFiles));
        long nextTransferTime = this.lastTransferTime + context.getProperty(IGNORE_TIME).asTimePeriod(TimeUnit.NANOSECONDS);
        if (System.nanoTime() < nextTransferTime) {
            this.getLogger().debug("Ignoring input because {} is not yet reached", new Object[]{context.getProperty(IGNORE_TIME).getValue()});
            return;
        }
        for (FlowFileSession flowFileSession : this.flowFileSessions) {
            ProcessSession processSession = flowFileSession.session();
            processSession.transfer(flowFileSession.flowFiles(), REL_SUCCESS);
            processSession.commitAsync();
        }
        this.getLogger().info("After ignoring input for {}, successfully transferred {} FlowFiles", new Object[]{context.getProperty(IGNORE_TIME).getValue(), flowFiles.size()});
        this.lastTransferTime = System.nanoTime();
    }

    private record FlowFileSession(ProcessSession session, List<FlowFile> flowFiles) {
    }
}

