/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.stream.io.StreamUtils;

public class UnzipFlowFile
extends AbstractProcessor {
    private final Relationship REL_UNZIPPED = new Relationship.Builder().name("unzipped").build();
    private final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").autoTerminateDefault(true).build();
    private final Relationship REL_FAILURE = new Relationship.Builder().name("failure").build();

    public Set<Relationship> getRelationships() {
        return new HashSet<Relationship>(Arrays.asList(this.REL_UNZIPPED, this.REL_ORIGINAL, this.REL_FAILURE));
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        ArrayList<FlowFile> created = new ArrayList<FlowFile>();
        try (InputStream in = session.read(flowFile);
             ZipInputStream zipInputStream = new ZipInputStream(in);){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String filename = zipEntry.getName();
                FlowFile outFile = session.create(flowFile);
                outFile = session.putAttribute(outFile, "filename", filename);
                created.add(outFile);
                session.write(outFile, out -> StreamUtils.copy((InputStream)zipInputStream, (OutputStream)out));
            }
        }
        catch (IOException e) {
            this.getLogger().error("Failed to unzip {}", new Object[]{flowFile, e});
            session.transfer(flowFile, this.REL_FAILURE);
            session.remove(created);
            return;
        }
        session.transfer(created, this.REL_UNZIPPED);
        session.transfer(flowFile, this.REL_ORIGINAL);
    }
}

