/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.util.List;
import java.util.Set;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

public class MigrateProperties
extends AbstractProcessor {
    static PropertyDescriptor INGEST = new PropertyDescriptor.Builder().name("ingest-data").displayName("Ingest Data").allowableValues(new String[]{"true", "false"}).defaultValue("true").required(true).build();
    static PropertyDescriptor ATTRIBUTE_NAME = new PropertyDescriptor.Builder().name("attr-to-add").displayName("Attribute to add").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static PropertyDescriptor ATTRIBUTE_VALUE = new PropertyDescriptor.Builder().name("attr-value").displayName("Attribute Value").required(true).dependsOn(ATTRIBUTE_NAME, new AllowableValue[0]).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static PropertyDescriptor IGNORED = new PropertyDescriptor.Builder().name("ignored").displayName("Ignored").required(false).addValidator(Validator.VALID).build();
    static Relationship REL_SUCCESS = new Relationship.Builder().name("success").build();
    static Relationship REL_FAILURE = new Relationship.Builder().name("failure").build();
    private static final Set<Relationship> relationships = Set.of(REL_SUCCESS, REL_FAILURE);
    private static final List<PropertyDescriptor> properties = List.of(INGEST, ATTRIBUTE_NAME, ATTRIBUTE_VALUE, IGNORED);

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String attributeValue = context.getProperty(ATTRIBUTE_VALUE).getValue();
        if (attributeValue != null) {
            String attributeName = context.getProperty(ATTRIBUTE_NAME).getValue();
            flowFile = session.putAttribute(flowFile, attributeName, attributeValue);
        }
        session.transfer(flowFile, REL_SUCCESS);
    }
}

