/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@DefaultSchedule(period="10 mins")
@Stateful(scopes={Scope.LOCAL, Scope.CLUSTER}, description="Stores the number of generated FlowFiles", dropStateKeySupported=true)
public class GenerateFlowFile
extends AbstractProcessor {
    public static final PropertyDescriptor FILE_SIZE = new PropertyDescriptor.Builder().name("File Size").description("The size of the file that will be used").required(true).defaultValue("0 B").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).build();
    public static final PropertyDescriptor BATCH_SIZE = new PropertyDescriptor.Builder().name("Batch Size").description("The number of FlowFiles to be transferred in each invocation").required(true).defaultValue("1").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor CUSTOM_TEXT = new PropertyDescriptor.Builder().name("Text").description("If Data Format is text and if Unique FlowFiles is false, then this custom text will be used as content of the generated FlowFiles and the File Size will be ignored. Finally, if Expression Language is used, evaluation will be performed only once per batch of generated FlowFiles").required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor STATE_SCOPE = new PropertyDescriptor.Builder().name("State Scope").displayName("State Scope").description("Whether to store state locally or in cluster").required(false).allowableValues(new String[]{"LOCAL", "CLUSTER"}).defaultValue("LOCAL").build();
    static final PropertyDescriptor MAX_FLOWFILES = new PropertyDescriptor.Builder().name("Max FlowFiles").displayName("Max FlowFiles").description("The maximum number of FlowFiles to generate. Once the Processor has generated this many FlowFiles, any additional calls to trigger the processor will produce no FlowFiles until the Processor has been stopped and started again").required(false).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    static final PropertyDescriptor FILE_TO_WRITE_ON_COMMIT_FAILURE = new PropertyDescriptor.Builder().name("File to Write on Commit Failure").displayName("File to Write on Commit Failure").description("Specifies a file to write in the event that ProcessSession commit fails").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").build();
    private final AtomicLong generatedCount = new AtomicLong(0L);
    private volatile Long maxFlowFiles = null;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Arrays.asList(FILE_SIZE, BATCH_SIZE, MAX_FLOWFILES, CUSTOM_TEXT, STATE_SCOPE, FILE_TO_WRITE_ON_COMMIT_FAILURE);
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).addValidator(StandardValidators.ATTRIBUTE_KEY_PROPERTY_NAME_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).dynamic(true).build();
    }

    public Set<Relationship> getRelationships() {
        return Collections.singleton(REL_SUCCESS);
    }

    @OnScheduled
    public void resetCount(ProcessContext context) {
        this.generatedCount.set(0L);
        this.maxFlowFiles = context.getProperty(MAX_FLOWFILES).asLong();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        if (this.maxFlowFiles != null && this.generatedCount.get() >= this.maxFlowFiles) {
            this.getLogger().info("Already generated maximum number of FlowFiles. Will not generate any FlowFiles this iteration.");
            return;
        }
        int numFlowFiles = context.getProperty(BATCH_SIZE).asInteger();
        for (int i = 0; i < numFlowFiles; ++i) {
            FlowFile flowFile = this.createFlowFile(context, session);
            session.transfer(flowFile, REL_SUCCESS);
        }
        this.getLogger().info("Generated {} FlowFiles", new Object[]{numFlowFiles});
        this.generatedCount.addAndGet(numFlowFiles);
        session.commitAsync(() -> {}, cause -> {
            String filename = context.getProperty(FILE_TO_WRITE_ON_COMMIT_FAILURE).getValue();
            if (filename == null) {
                return;
            }
            try (PrintWriter writer = new PrintWriter(new File(filename));){
                writer.println("Failed to commit session:");
                cause.printStackTrace(writer);
            }
            catch (Exception e) {
                this.getLogger().error("Failed to write to fail on session commit failure", (Throwable)e);
                throw new RuntimeException(e);
            }
        });
    }

    private FlowFile createFlowFile(ProcessContext context, ProcessSession session) {
        String customText;
        StateMap stateMap;
        Scope scope = Scope.valueOf((String)context.getProperty(STATE_SCOPE).getValue().toUpperCase());
        try {
            stateMap = session.getState(scope);
        }
        catch (IOException e) {
            throw new ProcessException((Throwable)e);
        }
        FlowFile flowFile = session.create();
        HashMap attributes = new HashMap();
        context.getProperties().keySet().forEach(descriptor -> {
            if (descriptor.isDynamic()) {
                String value = context.getProperty(descriptor).evaluateAttributeExpressions().getValue();
                attributes.put(descriptor.getName(), value);
            }
        });
        if (!attributes.isEmpty()) {
            flowFile = session.putAllAttributes(flowFile, attributes);
        }
        if ((customText = context.getProperty(CUSTOM_TEXT).evaluateAttributeExpressions().getValue()) == null) {
            int dataSize = context.getProperty(FILE_SIZE).asDataSize(DataUnit.B).intValue();
            if ((long)dataSize > 0L) {
                byte[] data = new byte[dataSize];
                Random random = new Random();
                random.nextBytes(data);
                flowFile = session.write(flowFile, out -> out.write(data));
            }
        } else {
            flowFile = session.write(flowFile, out -> out.write(customText.getBytes(StandardCharsets.UTF_8)));
        }
        String countValue = (String)stateMap.toMap().get("count");
        int count = countValue == null ? 0 : Integer.parseInt(countValue);
        try {
            session.setState(Collections.singletonMap("count", String.valueOf(count + 1)), scope);
        }
        catch (IOException e) {
            throw new ProcessException((Throwable)e);
        }
        return flowFile;
    }
}

