/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
public class YieldSource
extends AbstractProcessor {
    static final PropertyDescriptor YIELD_AFTER = new PropertyDescriptor.Builder().name("Yield After").description("The number of times to run before yielding").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).defaultValue("1").build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles go to this Relationship").build();
    private final AtomicLong flowFileCount = new AtomicLong(0L);

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return List.of(YIELD_AFTER);
    }

    public Set<Relationship> getRelationships() {
        return Set.of(REL_SUCCESS);
    }

    @OnScheduled
    public void reset() {
        this.flowFileCount.set(0L);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        long alreadyCreated = this.flowFileCount.getAndIncrement();
        if (alreadyCreated >= context.getProperty(YIELD_AFTER).asLong()) {
            context.yield();
            this.getLogger().info("Yielding after {} FlowFiles", new Object[]{alreadyCreated});
        } else {
            this.getLogger().info("Created FlowFile {} without yielding", new Object[]{alreadyCreated});
        }
        FlowFile flowFile = session.create();
        session.transfer(flowFile, REL_SUCCESS);
    }
}

