/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.cs.tests.system.CountService;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;

public class CountFlowFiles
extends AbstractProcessor {
    static final PropertyDescriptor COUNT_SERVICE = new PropertyDescriptor.Builder().name("Count Service").displayName("Count Service").description("The Controller Service to use for counting").required(true).identifiesControllerService(CountService.class).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Collections.singletonList(COUNT_SERVICE);
    }

    public Set<Relationship> getRelationships() {
        return Collections.singleton(REL_SUCCESS);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        CountService service = (CountService)context.getProperty(COUNT_SERVICE).asControllerService(CountService.class);
        long count = service.count();
        flowFile = session.putAttribute(flowFile, "count", String.valueOf(count));
        session.transfer(flowFile, REL_SUCCESS);
    }
}

