/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flow.registry;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.registry.flow.AbstractFlowRegistryClient;
import org.apache.nifi.registry.flow.BucketLocation;
import org.apache.nifi.registry.flow.FlowLocation;
import org.apache.nifi.registry.flow.FlowRegistryBucket;
import org.apache.nifi.registry.flow.FlowRegistryClientConfigurationContext;
import org.apache.nifi.registry.flow.FlowRegistryPermissions;
import org.apache.nifi.registry.flow.FlowVersionLocation;
import org.apache.nifi.registry.flow.RegisterAction;
import org.apache.nifi.registry.flow.RegisteredFlow;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshot;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshotMetadata;
import org.apache.nifi.registry.flow.RegisteredFlowVersionInfo;
import org.apache.nifi.util.file.FileUtils;

public class FileSystemFlowRegistryClient
extends AbstractFlowRegistryClient {
    private static final String TEST_FLOWS_BUCKET = "test-flows";
    private static final Set<String> FLOW_IDS = Set.of("first-flow", "flow-with-invalid-connection", "port-moved-groups", "Parent", "Child");
    private final ObjectMapper objectMapper = new ObjectMapper();
    static final PropertyDescriptor DIRECTORY = new PropertyDescriptor.Builder().name("Directory").displayName("Directory").description("The root directory to store flows in").required(true).addValidator(StandardValidators.createDirectoryExistsValidator((boolean)false, (boolean)false)).defaultValue("target/flow-registry-storage").build();

    public FileSystemFlowRegistryClient() {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_NULL, (JsonInclude.Include)JsonInclude.Include.NON_NULL));
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Collections.singletonList(DIRECTORY);
    }

    public boolean isStorageLocationApplicable(FlowRegistryClientConfigurationContext context, String storageLocation) {
        try {
            Path rootPath = this.getRootDirectory(context).toPath().normalize();
            URI location = URI.create(storageLocation);
            Path storageLocationPath = Paths.get(location.getPath(), new String[0]).normalize();
            if (!storageLocationPath.startsWith(rootPath)) {
                return false;
            }
            Objects.requireNonNull(rootPath.relativize(storageLocationPath));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Set<FlowRegistryBucket> getBuckets(FlowRegistryClientConfigurationContext context, String branch) throws IOException {
        File rootDir = this.getRootDirectory(context);
        File[] children = rootDir.listFiles();
        if (children == null) {
            throw new IOException("Cannot get listing of directory " + rootDir.getAbsolutePath());
        }
        return Arrays.stream(children).map(this::toBucket).collect(Collectors.toSet());
    }

    private FlowRegistryBucket toBucket(File file) {
        FlowRegistryBucket bucket = new FlowRegistryBucket();
        bucket.setIdentifier(file.getName());
        bucket.setName(bucket.getName());
        FlowRegistryPermissions permissions = new FlowRegistryPermissions();
        permissions.setCanDelete(true);
        permissions.setCanRead(true);
        permissions.setCanWrite(true);
        bucket.setPermissions(permissions);
        return bucket;
    }

    private File getRootDirectory(FlowRegistryClientConfigurationContext context) {
        String rootDirectory = context.getProperty(DIRECTORY).getValue();
        if (rootDirectory == null) {
            throw new IllegalStateException("Registry Client cannot be used, as Directory property has not been set");
        }
        return new File(rootDirectory);
    }

    public FlowRegistryBucket getBucket(FlowRegistryClientConfigurationContext context, BucketLocation bucketLocation) {
        File rootDir = this.getRootDirectory(context);
        File bucketDir = this.getChildLocation(rootDir, this.getValidatedBucketPath(bucketLocation.getBucketId()));
        return this.toBucket(bucketDir);
    }

    public RegisteredFlow registerFlow(FlowRegistryClientConfigurationContext context, RegisteredFlow flow) throws IOException {
        String bucketId = flow.getBucketIdentifier();
        File flowDir = this.getFlowDirectory(context, bucketId, flow.getIdentifier());
        Files.createDirectories(flowDir.toPath(), new FileAttribute[0]);
        return flow;
    }

    public RegisteredFlow deregisterFlow(FlowRegistryClientConfigurationContext context, FlowLocation flowLocation) throws IOException {
        String bucketId = flowLocation.getBucketId();
        String flowId = flowLocation.getFlowId();
        File flowDir = this.getFlowDirectory(context, bucketId, flowId);
        File[] versionDirs = flowDir.listFiles();
        RegisteredFlow flow = new RegisteredFlow();
        flow.setBucketIdentifier(bucketId);
        flow.setBucketName(bucketId);
        flow.setIdentifier(flowId);
        flow.setLastModifiedTimestamp(flowDir.lastModified());
        flow.setVersionCount(versionDirs == null ? 0L : (long)versionDirs.length);
        FileUtils.deleteFile((File)flowDir, (boolean)true);
        return flow;
    }

    public RegisteredFlow getFlow(FlowRegistryClientConfigurationContext context, FlowLocation flowLocation) {
        String bucketId = flowLocation.getBucketId();
        String flowId = flowLocation.getFlowId();
        File flowDir = this.getFlowDirectory(context, bucketId, flowId);
        File[] versionDirs = flowDir.listFiles();
        RegisteredFlow flow = new RegisteredFlow();
        flow.setBucketIdentifier(bucketId);
        flow.setBucketName(bucketId);
        flow.setIdentifier(flowId);
        flow.setLastModifiedTimestamp(flowDir.lastModified());
        flow.setVersionCount(versionDirs == null ? 0L : (long)versionDirs.length);
        return flow;
    }

    public Set<RegisteredFlow> getFlows(FlowRegistryClientConfigurationContext context, BucketLocation bucketLocation) throws IOException {
        String bucketId = bucketLocation.getBucketId();
        File rootDir = this.getRootDirectory(context);
        File bucketDir = this.getChildLocation(rootDir, this.getValidatedBucketPath(bucketId));
        File[] flowDirs = bucketDir.listFiles();
        if (flowDirs == null) {
            throw new IOException("Could not get listing of directory " + String.valueOf(bucketDir));
        }
        HashSet<RegisteredFlow> registeredFlows = new HashSet<RegisteredFlow>();
        for (File flowDir : flowDirs) {
            FlowLocation flowLocation = new FlowLocation();
            flowLocation.setBucketId(bucketId);
            flowLocation.setFlowId(flowDir.getName());
            RegisteredFlow flow = this.getFlow(context, flowLocation);
            registeredFlows.add(flow);
        }
        return registeredFlows;
    }

    public RegisteredFlowSnapshot getFlowContents(FlowRegistryClientConfigurationContext context, FlowVersionLocation flowVersionLocation) throws IOException {
        String bucketId = flowVersionLocation.getBucketId();
        String flowId = flowVersionLocation.getFlowId();
        String version = flowVersionLocation.getVersion();
        File flowDir = this.getFlowDirectory(context, bucketId, flowId);
        Pattern intPattern = Pattern.compile("\\d+");
        File[] versionFiles = flowDir.listFiles(file -> intPattern.matcher(file.getName()).matches());
        JsonFactory factory = new JsonFactory((ObjectCodec)this.objectMapper);
        File snapshotFile = this.getSnapshotFile(context, bucketId, flowId, version);
        try (JsonParser parser = factory.createParser(snapshotFile);){
            RegisteredFlowSnapshot snapshot = (RegisteredFlowSnapshot)parser.readValueAs(RegisteredFlowSnapshot.class);
            this.populateBucket(snapshot, bucketId);
            this.populateFlow(snapshot, bucketId, flowId, versionFiles == null ? 0 : versionFiles.length);
            RegisteredFlowSnapshot registeredFlowSnapshot = snapshot;
            return registeredFlowSnapshot;
        }
    }

    private void populateBucket(RegisteredFlowSnapshot snapshot, String bucketId) {
        FlowRegistryBucket existingBucket = snapshot.getBucket();
        if (existingBucket != null) {
            return;
        }
        FlowRegistryBucket bucket = new FlowRegistryBucket();
        bucket.setCreatedTimestamp(System.currentTimeMillis());
        bucket.setIdentifier(bucketId);
        bucket.setName(bucketId);
        bucket.setPermissions(this.createAllowAllPermissions());
        snapshot.setBucket(bucket);
        snapshot.getSnapshotMetadata().setBucketIdentifier(bucketId);
    }

    private void populateFlow(RegisteredFlowSnapshot snapshot, String bucketId, String flowId, int numVersions) {
        RegisteredFlow existingFlow = snapshot.getFlow();
        if (existingFlow != null) {
            return;
        }
        RegisteredFlow flow = new RegisteredFlow();
        flow.setCreatedTimestamp(System.currentTimeMillis());
        flow.setLastModifiedTimestamp(System.currentTimeMillis());
        flow.setBucketIdentifier(bucketId);
        flow.setBucketName(bucketId);
        flow.setIdentifier(flowId);
        flow.setName(flowId);
        flow.setPermissions(this.createAllowAllPermissions());
        flow.setVersionCount((long)numVersions);
        RegisteredFlowVersionInfo versionInfo = new RegisteredFlowVersionInfo();
        versionInfo.setVersion((long)numVersions);
        flow.setVersionInfo(versionInfo);
        snapshot.setFlow(flow);
        snapshot.getSnapshotMetadata().setFlowIdentifier(flowId);
    }

    public RegisteredFlowSnapshot registerFlowSnapshot(FlowRegistryClientConfigurationContext context, RegisteredFlowSnapshot flowSnapshot, RegisterAction registerAction) throws IOException {
        RegisteredFlowSnapshotMetadata metadata = flowSnapshot.getSnapshotMetadata();
        String bucketId = metadata.getBucketIdentifier();
        String flowId = metadata.getFlowIdentifier();
        File flowDir = this.getFlowDirectory(context, bucketId, flowId);
        String version = metadata.getVersion() == null ? "1" : String.valueOf(Integer.parseInt(metadata.getVersion()) + 1);
        flowSnapshot.getSnapshotMetadata().setVersion(version);
        File versionDir = this.getChildLocation(flowDir, Paths.get(version, new String[0]));
        if (!versionDir.exists()) {
            Files.createDirectories(versionDir.toPath(), new FileAttribute[0]);
        }
        File snapshotFile = this.getSnapshotFile(context, bucketId, flowId, version);
        RegisteredFlowSnapshot fullyPopulated = this.fullyPopulate(flowSnapshot, flowDir);
        JsonFactory factory = new JsonFactory((ObjectCodec)this.objectMapper);
        try (JsonGenerator generator = factory.createGenerator(snapshotFile, JsonEncoding.UTF8);){
            generator.writeObject((Object)fullyPopulated);
        }
        return fullyPopulated;
    }

    private RegisteredFlowSnapshot fullyPopulate(RegisteredFlowSnapshot requested, File flowDir) {
        RegisteredFlow flow;
        FlowRegistryBucket bucket;
        RegisteredFlowSnapshot full = new RegisteredFlowSnapshot();
        full.setExternalControllerServices(requested.getExternalControllerServices());
        full.setFlowContents(requested.getFlowContents());
        full.setFlowEncodingVersion(requested.getFlowEncodingVersion());
        full.setParameterContexts(requested.getParameterContexts());
        full.setParameterProviders(requested.getParameterProviders());
        full.setSnapshotMetadata(requested.getSnapshotMetadata());
        if (requested.getBucket() == null) {
            bucket = new FlowRegistryBucket();
            bucket.setCreatedTimestamp(System.currentTimeMillis());
            bucket.setDescription("Description");
            bucket.setIdentifier(requested.getSnapshotMetadata().getBucketIdentifier());
            bucket.setName(requested.getSnapshotMetadata().getBucketIdentifier());
            FlowRegistryPermissions bucketPermissions = this.createAllowAllPermissions();
            bucket.setPermissions(bucketPermissions);
        } else {
            bucket = requested.getBucket();
        }
        full.setBucket(bucket);
        if (requested.getFlow() == null) {
            flow = new RegisteredFlow();
            flow.setBucketIdentifier(requested.getSnapshotMetadata().getBucketIdentifier());
            flow.setBucketName(requested.getSnapshotMetadata().getBucketIdentifier());
            flow.setCreatedTimestamp(System.currentTimeMillis());
            flow.setDescription("Description");
            flow.setIdentifier(requested.getSnapshotMetadata().getFlowIdentifier());
            flow.setName(requested.getSnapshotMetadata().getFlowIdentifier());
            flow.setLastModifiedTimestamp(System.currentTimeMillis());
            flow.setPermissions(this.createAllowAllPermissions());
            File[] flowVersionDirs = flowDir.listFiles();
            int versionCount = flowVersionDirs == null ? 0 : flowVersionDirs.length;
            flow.setVersionCount((long)versionCount);
            RegisteredFlowVersionInfo versionInfo = new RegisteredFlowVersionInfo();
            versionInfo.setVersion((long)versionCount);
            flow.setVersionInfo(versionInfo);
        } else {
            flow = requested.getFlow();
        }
        full.setFlow(flow);
        return full;
    }

    private FlowRegistryPermissions createAllowAllPermissions() {
        FlowRegistryPermissions permissions = new FlowRegistryPermissions();
        permissions.setCanWrite(true);
        permissions.setCanRead(true);
        permissions.setCanDelete(true);
        return permissions;
    }

    public Set<RegisteredFlowSnapshotMetadata> getFlowVersions(FlowRegistryClientConfigurationContext context, FlowLocation flowLocation) throws IOException {
        String flowId;
        String bucketId = flowLocation.getBucketId();
        File flowDir = this.getFlowDirectory(context, bucketId, flowId = flowLocation.getFlowId());
        File[] versionDirs = flowDir.listFiles();
        if (versionDirs == null) {
            throw new IOException("Could not list directories of " + String.valueOf(flowDir));
        }
        HashSet<RegisteredFlowSnapshotMetadata> metadatas = new HashSet<RegisteredFlowSnapshotMetadata>();
        for (File versionDir : versionDirs) {
            String versionName = versionDir.getName();
            RegisteredFlowSnapshotMetadata metadata = new RegisteredFlowSnapshotMetadata();
            metadata.setVersion(versionName);
            metadata.setTimestamp(versionDir.lastModified());
            metadata.setFlowIdentifier(flowId);
            metadata.setBucketIdentifier(bucketId);
            metadata.setAuthor("System Test Author");
            metadatas.add(metadata);
        }
        return metadatas;
    }

    public Optional<String> getLatestVersion(FlowRegistryClientConfigurationContext context, FlowLocation flowLocation) throws IOException {
        String flowId;
        String bucketId = flowLocation.getBucketId();
        int latestVersion = this.getLatestFlowVersionInt(context, bucketId, flowId = flowLocation.getFlowId());
        return latestVersion == -1 ? Optional.empty() : Optional.of(String.valueOf(latestVersion));
    }

    private int getLatestFlowVersionInt(FlowRegistryClientConfigurationContext context, String bucketId, String flowId) throws IOException {
        File flowDir = this.getFlowDirectory(context, bucketId, flowId);
        File[] versionDirs = flowDir.listFiles();
        if (versionDirs == null) {
            throw new IOException("Cannot list directories of " + String.valueOf(flowDir));
        }
        OptionalInt greatestValue = Arrays.stream(versionDirs).map(File::getName).mapToInt(Integer::parseInt).max();
        return greatestValue.orElse(-1);
    }

    private File getSnapshotFile(FlowRegistryClientConfigurationContext context, String bucketId, String flowId, String version) {
        File flowDirectory = this.getFlowDirectory(context, bucketId, flowId);
        File versionDirectory = this.getChildLocation(flowDirectory, Paths.get(String.valueOf(version), new String[0]));
        return new File(versionDirectory, "snapshot.json");
    }

    private File getFlowDirectory(FlowRegistryClientConfigurationContext context, String bucketId, String flowId) {
        File rootDir = this.getRootDirectory(context);
        File bucketDir = this.getChildLocation(rootDir, this.getValidatedBucketPath(bucketId));
        return this.getChildLocation(bucketDir, this.getFlowPath(flowId));
    }

    private File getChildLocation(File parentDir, Path childLocation) {
        Path parentPath = parentDir.toPath().normalize();
        Path childPath = parentPath.resolve(childLocation.normalize());
        if (childPath.startsWith(parentPath)) {
            return childPath.toFile();
        }
        throw new IllegalArgumentException(String.format("Child location not valid [%s]", childLocation));
    }

    private Path getFlowPath(String flowId) {
        Optional<String> flowIdFound = FLOW_IDS.stream().filter(id -> id.equals(flowId)).findFirst();
        if (flowIdFound.isPresent()) {
            return Paths.get(flowIdFound.get(), new String[0]);
        }
        try {
            UUID flowIdentifier = UUID.fromString(flowId);
            return Paths.get(flowIdentifier.toString(), new String[0]);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(String.format("Flow ID [%s] not validated", flowId));
        }
    }

    private Path getValidatedBucketPath(String id) {
        if (TEST_FLOWS_BUCKET.equals(id)) {
            return Paths.get(TEST_FLOWS_BUCKET, new String[0]);
        }
        throw new IllegalArgumentException(String.format("Bucket [%s] not validated", id));
    }
}

