/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@DefaultSchedule(period="10 mins")
public class GenerateFlowFile
extends AbstractProcessor {
    public static final PropertyDescriptor FILE_SIZE = new PropertyDescriptor.Builder().name("File Size").description("The size of the file that will be used").required(true).defaultValue("0 B").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).build();
    public static final PropertyDescriptor BATCH_SIZE = new PropertyDescriptor.Builder().name("Batch Size").description("The number of FlowFiles to be transferred in each invocation").required(true).defaultValue("1").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor CUSTOM_TEXT = new PropertyDescriptor.Builder().name("Text").description("If Data Format is text and if Unique FlowFiles is false, then this custom text will be used as content of the generated FlowFiles and the File Size will be ignored. Finally, if Expression Language is used, evaluation will be performed only once per batch of generated FlowFiles").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Arrays.asList(FILE_SIZE, BATCH_SIZE, CUSTOM_TEXT);
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).addValidator(StandardValidators.ATTRIBUTE_KEY_PROPERTY_NAME_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).dynamic(true).build();
    }

    public Set<Relationship> getRelationships() {
        return Collections.singleton(REL_SUCCESS);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        int numFlowFiles = context.getProperty(BATCH_SIZE).asInteger();
        for (int i = 0; i < numFlowFiles; ++i) {
            FlowFile flowFile = this.createFlowFile(context, session);
            session.transfer(flowFile, REL_SUCCESS);
        }
    }

    private FlowFile createFlowFile(ProcessContext context, ProcessSession session) {
        String customText;
        FlowFile flowFile = session.create();
        HashMap attributes = new HashMap();
        context.getProperties().keySet().forEach(descriptor -> {
            if (descriptor.isDynamic()) {
                String value = context.getProperty(descriptor).evaluateAttributeExpressions().getValue();
                attributes.put(descriptor.getName(), value);
            }
        });
        if (!attributes.isEmpty()) {
            flowFile = session.putAllAttributes(flowFile, attributes);
        }
        if ((customText = context.getProperty(CUSTOM_TEXT).evaluateAttributeExpressions().getValue()) == null) {
            int dataSize = context.getProperty(FILE_SIZE).asDataSize(DataUnit.B).intValue();
            if ((long)dataSize > 0L) {
                byte[] data = new byte[dataSize];
                Random random = new Random();
                random.nextBytes(data);
                flowFile = session.write(flowFile, out -> out.write(data));
            }
        } else {
            flowFile = session.write(flowFile, out -> out.write(customText.getBytes(StandardCharsets.UTF_8)));
        }
        return flowFile;
    }
}

