/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.annotation.lifecycle.OnUnscheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.AbstractSessionFactoryProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.exception.ProcessException;

@SupportsBatching
public class CountEvents
extends AbstractSessionFactoryProcessor {
    private volatile ProcessSessionFactory sessionFactory;
    private final AtomicBoolean firstScheduleCounted = new AtomicBoolean(false);
    static final PropertyDescriptor NAME = new PropertyDescriptor.Builder().name("Name").displayName("Name").description("Arbitrary Name").required(false).addValidator(Validator.VALID).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    static final PropertyDescriptor SENSITIVE = new PropertyDescriptor.Builder().name("Sensitive").displayName("Sensitive").description("Sensitive Property with no real meaning").required(false).addValidator(Validator.VALID).expressionLanguageSupported(ExpressionLanguageScope.NONE).sensitive(true).build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Arrays.asList(NAME, SENSITIVE);
    }

    @OnStopped
    public void onStopped() {
        this.sessionFactory.createSession().adjustCounter("Stopped", 1L, true);
    }

    @OnScheduled
    public void onScheduled() {
        if (this.sessionFactory != null) {
            this.sessionFactory.createSession().adjustCounter("Scheduled", 1L, true);
        }
    }

    @OnUnscheduled
    public void onUnScheduled() {
        if (this.sessionFactory != null) {
            this.sessionFactory.createSession().adjustCounter("UnScheduled", 1L, true);
        }
    }

    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        this.sessionFactory = sessionFactory;
        ProcessSession session = sessionFactory.createSession();
        if (!this.firstScheduleCounted.getAndSet(true)) {
            session.adjustCounter("Scheduled", 1L, true);
        }
        session.adjustCounter("Triggered", 1L, true);
    }
}

