/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cs.tests.system;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.cs.tests.system.SetStateService;
import org.apache.nifi.processor.util.StandardValidators;

public class VerifyLocalClusterStateService
extends AbstractControllerService
implements SetStateService {
    static final PropertyDescriptor FILE_STORAGE_LOCATION = new PropertyDescriptor.Builder().name("File Storage Location").description("The file system location where state files will be written.").addValidator(StandardValidators.createDirectoryExistsValidator((boolean)false, (boolean)true)).required(true).build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return List.of(FILE_STORAGE_LOCATION);
    }

    @OnEnabled
    public void onScheduled(ConfigurationContext context) throws IOException {
        String nodeNumber = System.getProperty("nodeNumber");
        StateManager stateManager = this.getStateManager();
        Map clusterState = stateManager.getState(Scope.CLUSTER).toMap();
        Map localState = stateManager.getState(Scope.LOCAL).toMap();
        File directory = new File(context.getProperty(FILE_STORAGE_LOCATION).getValue());
        this.writeToPropertiesFile(clusterState, new File(directory, "cluster-state-" + nodeNumber + ".properties"));
        this.writeToPropertiesFile(localState, new File(directory, "local-state-" + nodeNumber + ".properties"));
    }

    private void writeToPropertiesFile(Map<String, String> stateMap, File file) throws IOException {
        Properties properties = new Properties();
        stateMap.forEach(properties::setProperty);
        try (FileOutputStream out = new FileOutputStream(file);){
            properties.store(out, "State Map");
        }
    }

    public void setState(String key, String value, Scope scope) throws IOException {
        HashMap<String, String> state = new HashMap<String, String>(this.getStateManager().getState(scope).toMap());
        state.put(key, value);
        this.getStateManager().setState(state, scope);
    }
}

