/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cs.tests.system;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.cs.tests.system.SleepService;
import org.apache.nifi.processor.util.StandardValidators;

public class StandardSleepService
extends AbstractControllerService
implements SleepService {
    public static final PropertyDescriptor VALIDATE_SLEEP_TIME = new PropertyDescriptor.Builder().name("Validate Sleep Time").description("The amount of time to sleep during validation").required(false).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("0 sec").build();
    public static final PropertyDescriptor TRIGGER_SLEEP_TIME = new PropertyDescriptor.Builder().name("Trigger Sleep Time").description("The amount of time to sleep during each trigger").required(false).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("0 sec").build();
    public static final PropertyDescriptor ON_ENABLED_SLEEP_TIME = new PropertyDescriptor.Builder().name("@OnEnabled Sleep Time").description("The amount of time to sleep when enabled").required(false).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("0 sec").build();
    public static final PropertyDescriptor ON_DISABLED_SLEEP_TIME = new PropertyDescriptor.Builder().name("@OnDisabled Sleep Time").description("The amount of time to sleep when disabled").required(false).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("0 sec").build();
    public static final PropertyDescriptor DEPENDENT_SERVICE = new PropertyDescriptor.Builder().name("Dependent Service").description("Another Controller Service that this one depends on. This is helpful for testing when Service A depends on Service B how enabling/disabling/etc. work").required(false).identifiesControllerService(SleepService.class).build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return List.of(VALIDATE_SLEEP_TIME, ON_ENABLED_SLEEP_TIME, TRIGGER_SLEEP_TIME, ON_DISABLED_SLEEP_TIME, DEPENDENT_SERVICE);
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        long sleepMillis = validationContext.getProperty(VALIDATE_SLEEP_TIME).asTimePeriod(TimeUnit.MILLISECONDS);
        this.sleep(sleepMillis);
        return Collections.emptyList();
    }

    private void sleep(long millis) {
        if (millis > 0L) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.sleep(context.getProperty(ON_ENABLED_SLEEP_TIME).asTimePeriod(TimeUnit.MILLISECONDS));
    }

    @OnDisabled
    public void onDisabled(ConfigurationContext context) {
        this.sleep(context.getProperty(ON_DISABLED_SLEEP_TIME).asTimePeriod(TimeUnit.MILLISECONDS));
    }

    public void sleep() {
        this.sleep(this.getConfigurationContext().getProperty(TRIGGER_SLEEP_TIME).asTimePeriod(TimeUnit.MILLISECONDS));
        SleepService dependentService = (SleepService)this.getConfigurationContext().getProperty(DEPENDENT_SERVICE).asControllerService(SleepService.class);
        if (dependentService != null) {
            dependentService.sleep();
        }
    }
}

