/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cs.tests.system;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.processor.util.StandardValidators;

public class LifecycleFailureService
extends AbstractControllerService {
    static final PropertyDescriptor ENABLE_FAILURE_COUNT = new PropertyDescriptor.Builder().name("Enable Failure Count").description("How many times the CS should fail to enable before succeeding").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).defaultValue("0").build();
    static final PropertyDescriptor FAIL_ON_DISABLE = new PropertyDescriptor.Builder().name("Fail on Disable").displayName("Fail on Disable").description("Whether or not hte Controller Service should fail when disabled").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    private final AtomicInteger invocationCount = new AtomicInteger(0);

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Arrays.asList(ENABLE_FAILURE_COUNT, FAIL_ON_DISABLE);
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        int maxFailureCount = context.getProperty(ENABLE_FAILURE_COUNT).asInteger();
        int currentInvocationCount = this.invocationCount.getAndIncrement();
        if (currentInvocationCount >= maxFailureCount) {
            this.getLogger().info("Enabling successfully because invocation count is {}", new Object[]{currentInvocationCount});
            return;
        }
        this.getLogger().info("Will fail to enable because invocation count is {}", new Object[]{currentInvocationCount});
        throw new RuntimeException("Failing to enable because configured to fail " + maxFailureCount + " times and current failure count is only " + currentInvocationCount);
    }

    @OnDisabled
    public void onDisabled(ConfigurationContext context) {
        if (context.getProperty(FAIL_ON_DISABLE).asBoolean().booleanValue()) {
            this.getLogger().info("Throwing Exception in onDisabled as configured");
            throw new RuntimeException("Failing to disable because configured to fail on disable");
        }
        this.getLogger().info("Completing onDisabled successfully as configured");
    }
}

