/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardExpressionLanguageCompiler;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.expression.ExpressionLanguageCompiler;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.parameter.ParameterReference;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.stateless.core.StatelessControllerServiceLookup;
import org.apache.nifi.stateless.core.StatelessProcessContext;
import org.apache.nifi.stateless.core.StatelessPropertyValue;

public class StatelessValidationContext
implements ValidationContext {
    private final StatelessControllerServiceLookup lookup;
    private final Map<String, Boolean> expressionLanguageSupported;
    private final StateManager stateManager;
    private final VariableRegistry variableRegistry;
    private final StatelessProcessContext processContext;
    private final ParameterContext parameterContext;

    public StatelessValidationContext(StatelessProcessContext processContext, StatelessControllerServiceLookup lookup, StateManager stateManager, VariableRegistry variableRegistry, ParameterContext parameterContext) {
        this.processContext = processContext;
        this.lookup = lookup;
        this.stateManager = stateManager;
        this.variableRegistry = variableRegistry;
        Map<PropertyDescriptor, String> properties = processContext.getProperties();
        this.expressionLanguageSupported = new HashMap<String, Boolean>(properties.size());
        for (PropertyDescriptor descriptor : properties.keySet()) {
            this.expressionLanguageSupported.put(descriptor.getName(), descriptor.isExpressionLanguageSupported());
        }
        this.parameterContext = parameterContext;
    }

    public PropertyValue newPropertyValue(String rawValue) {
        return new StatelessPropertyValue(rawValue, this.lookup, (ParameterLookup)this.parameterContext, this.variableRegistry);
    }

    public ExpressionLanguageCompiler newExpressionLanguageCompiler() {
        return new StandardExpressionLanguageCompiler(this.variableRegistry, (ParameterLookup)this.parameterContext);
    }

    public ValidationContext getControllerServiceValidationContext(ControllerService controllerService) {
        StatelessProcessContext serviceProcessContext = new StatelessProcessContext((ConfigurableComponent)controllerService, this.lookup, null, this.stateManager, this.variableRegistry, this.parameterContext);
        return new StatelessValidationContext(serviceProcessContext, this.lookup, this.stateManager, this.variableRegistry, this.parameterContext);
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        return this.processContext.getProperty(property);
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return this.processContext.getProperties();
    }

    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : this.getProperties().entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propValueMap;
    }

    public String getAnnotationData() {
        return this.processContext.getAnnotationData();
    }

    public boolean isExpressionLanguagePresent(String value) {
        if (value == null) {
            return false;
        }
        List elRanges = Query.extractExpressionRanges((String)value);
        return elRanges != null && !elRanges.isEmpty();
    }

    public boolean isExpressionLanguageSupported(String propertyName) {
        Boolean supported = this.expressionLanguageSupported.get(propertyName);
        return Boolean.TRUE.equals(supported);
    }

    public String getProcessGroupIdentifier() {
        return "stateless";
    }

    public Collection<String> getReferencedParameters(String propertyName) {
        PropertyDescriptor descriptor = new PropertyDescriptor.Builder().name(propertyName).build();
        PropertyConfiguration configuration = this.processContext.getPropertyConfiguration(descriptor);
        if (configuration == null) {
            return Collections.emptyList();
        }
        List references = configuration.getParameterReferences();
        List<String> parameterNames = references.stream().map(ParameterReference::getParameterName).collect(Collectors.toList());
        return parameterNames;
    }

    public boolean isParameterDefined(String parameterName) {
        if (this.parameterContext == null) {
            return false;
        }
        return this.parameterContext.getParameter(parameterName).isPresent();
    }

    public boolean isParameterSet(String parameterName) {
        if (this.parameterContext == null) {
            return false;
        }
        Optional parameterOption = this.parameterContext.getParameter(parameterName);
        if (!parameterOption.isPresent()) {
            return false;
        }
        String value = ((Parameter)parameterOption.get()).getValue();
        return value != null;
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this.lookup;
    }

    public boolean isValidationRequired(ControllerService service) {
        return true;
    }
}

