/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.core;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.stateless.core.StatelessStateMap;

public class StatelessStateManager
implements StateManager {
    private final AtomicInteger versionIndex = new AtomicInteger(0);
    private Map<Scope, StatelessStateMap> maps = new HashMap<Scope, StatelessStateMap>();

    public StatelessStateManager() {
        for (Scope s : Scope.values()) {
            this.maps.put(s, new StatelessStateMap(null, -1L));
        }
    }

    public synchronized void setState(Map<String, String> state, Scope scope) {
        this.maps.put(scope, new StatelessStateMap(state, this.versionIndex.incrementAndGet()));
    }

    public synchronized StateMap getState(Scope scope) {
        return this.maps.get(scope);
    }

    public synchronized boolean replace(StateMap oldValue, Map<String, String> newValue, Scope scope) throws IOException {
        if (oldValue == this.maps.get(scope)) {
            this.maps.put(scope, new StatelessStateMap(newValue, this.versionIndex.incrementAndGet()));
            return true;
        }
        return false;
    }

    public synchronized void clear(Scope scope) {
        this.setState(Collections.emptyMap(), scope);
    }
}

