/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.core;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.registry.flow.VersionedRemoteGroupPort;
import org.apache.nifi.registry.flow.VersionedRemoteProcessGroup;
import org.apache.nifi.remote.Transaction;
import org.apache.nifi.remote.TransferDirection;
import org.apache.nifi.remote.client.SiteToSiteClient;
import org.apache.nifi.remote.protocol.DataPacket;
import org.apache.nifi.remote.protocol.SiteToSiteTransportProtocol;
import org.apache.nifi.remote.util.StandardDataPacket;
import org.apache.nifi.stateless.bootstrap.InMemoryFlowFile;
import org.apache.nifi.stateless.core.AbstractStatelessComponent;
import org.apache.nifi.stateless.core.SLF4JComponentLog;
import org.apache.nifi.stateless.core.StatelessConnectionContext;
import org.apache.nifi.stateless.core.StatelessFlowFile;
import org.apache.nifi.util.FormatUtils;

public class StatelessRemoteInputPort
extends AbstractStatelessComponent {
    private final Queue<StatelessFlowFile> inputQueue = new LinkedList<StatelessFlowFile>();
    private final SiteToSiteClient client;
    private final String name;
    private final String url;
    private final ComponentLog logger = new SLF4JComponentLog(this);
    private final StatelessConnectionContext connectionContext = new StatelessConnectionContext(){

        @Override
        public void addConnection(Relationship relationship) {
        }

        @Override
        public boolean isValid() {
            return true;
        }
    };

    public StatelessRemoteInputPort(VersionedRemoteProcessGroup rpg, VersionedRemoteGroupPort remotePort, SSLContext sslContext) {
        String timeout = rpg.getCommunicationsTimeout();
        long timeoutMillis = FormatUtils.getTimeDuration((String)timeout, (TimeUnit)TimeUnit.MILLISECONDS);
        this.url = rpg.getTargetUris();
        this.name = remotePort.getName();
        this.client = new SiteToSiteClient.Builder().portName(remotePort.getName()).timeout(timeoutMillis, TimeUnit.MILLISECONDS).transportProtocol(SiteToSiteTransportProtocol.valueOf((String)rpg.getTransportProtocol())).url(rpg.getTargetUris()).useCompression(remotePort.isUseCompression().booleanValue()).sslContext(sslContext).eventReporter(EventReporter.NO_OP).build();
    }

    @Override
    public Set<Relationship> getRelationships() {
        return Collections.emptySet();
    }

    @Override
    protected StatelessConnectionContext getContext() {
        return this.connectionContext;
    }

    @Override
    protected ComponentLog getLogger() {
        return this.logger;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void enqueueAll(Queue<StatelessFlowFile> list) {
        this.inputQueue.addAll(list);
    }

    @Override
    public boolean runRecursive(Queue<InMemoryFlowFile> queue) {
        try {
            StatelessFlowFile flowFile;
            Transaction transaction = this.client.createTransaction(TransferDirection.SEND);
            if (transaction == null) {
                this.getLogger().error("Unable to create a transaction for Remote Process Group {} to send to port {}", new Object[]{this.url, this.name});
                return false;
            }
            while ((flowFile = this.inputQueue.poll()) != null) {
                StandardDataPacket dataPacket = new StandardDataPacket(flowFile.getAttributes(), flowFile.getDataStream(), flowFile.getSize());
                transaction.send((DataPacket)dataPacket);
            }
            transaction.confirm();
            transaction.complete();
        }
        catch (Exception e) {
            this.getLogger().error("Failed to send FlowFile via site-to-site", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean isMaterializeContent() {
        return false;
    }
}

