/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.core;

import java.io.File;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.stateless.core.SLF4JComponentLog;

public class StatelessProcessorInitializationContext
implements ProcessorInitializationContext {
    private final ComponentLog logger;
    private final String processorId;
    private final ControllerServiceLookup controllerServiceLookup;

    public StatelessProcessorInitializationContext(String id, Processor processor, ProcessContext context) {
        this.processorId = id;
        this.logger = new SLF4JComponentLog(processor);
        this.controllerServiceLookup = context.getControllerServiceLookup();
    }

    public StatelessProcessorInitializationContext(String id, Processor processor, ControllerServiceLookup controllerServiceLookup) {
        this.processorId = id;
        this.logger = new SLF4JComponentLog(processor);
        this.controllerServiceLookup = controllerServiceLookup;
    }

    public String getIdentifier() {
        return this.processorId;
    }

    public ComponentLog getLogger() {
        return this.logger;
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this.controllerServiceLookup;
    }

    public NodeTypeProvider getNodeTypeProvider() {
        return new NodeTypeProvider(){

            public boolean isClustered() {
                return false;
            }

            public boolean isPrimary() {
                return false;
            }
        };
    }

    public String getKerberosServicePrincipal() {
        return null;
    }

    public File getKerberosServiceKeytab() {
        return null;
    }

    public File getKerberosConfigurationFile() {
        return null;
    }
}

