/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.parameter.ExpressionLanguageAgnosticParameterParser;
import org.apache.nifi.parameter.ExpressionLanguageAwareParameterParser;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.parameter.ParameterReference;
import org.apache.nifi.parameter.ParameterTokenList;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.scheduling.ExecutionNode;
import org.apache.nifi.stateless.core.SLF4JComponentLog;
import org.apache.nifi.stateless.core.StatelessConnectionContext;
import org.apache.nifi.stateless.core.StatelessControllerServiceConfiguration;
import org.apache.nifi.stateless.core.StatelessControllerServiceLookup;
import org.apache.nifi.stateless.core.StatelessPropertyValue;
import org.apache.nifi.stateless.core.StatelessStateManager;
import org.apache.nifi.stateless.core.StatelessValidationContext;

public class StatelessProcessContext
implements ProcessContext,
ControllerServiceInitializationContext,
StatelessConnectionContext {
    private final ConfigurableComponent component;
    private final String componentName;
    private final Map<PropertyDescriptor, PropertyConfiguration> properties = new HashMap<PropertyDescriptor, PropertyConfiguration>();
    private final StateManager stateManager;
    private final VariableRegistry variableRegistry;
    private final ParameterContext parameterContext;
    private String annotationData = null;
    private boolean yieldCalled = false;
    private boolean enableExpressionValidation = false;
    private boolean allowExpressionValidation = true;
    private volatile boolean incomingConnection = true;
    private volatile boolean nonLoopConnection = true;
    private volatile InputRequirement inputRequirement = null;
    private int maxConcurrentTasks = 1;
    private volatile Set<Relationship> connections = new HashSet<Relationship>();
    private volatile Set<Relationship> unavailableRelationships = new HashSet<Relationship>();
    private final String identifier;
    private final SLF4JComponentLog logger;
    private final StatelessControllerServiceLookup lookup;

    public StatelessProcessContext(ConfigurableComponent component, StatelessControllerServiceLookup lookup, String componentName, StateManager stateManager, VariableRegistry variableRegistry, ParameterContext parameterContext) {
        this(component, lookup, componentName, new SLF4JComponentLog(component), stateManager, variableRegistry, parameterContext);
    }

    public StatelessProcessContext(ConfigurableComponent component, StatelessControllerServiceLookup lookup, String componentName, SLF4JComponentLog logger, StatelessStateManager statemanager, ParameterContext parameterContext) {
        this(component, lookup, componentName, logger, statemanager, VariableRegistry.EMPTY_REGISTRY, parameterContext);
    }

    public StatelessProcessContext(ConfigurableComponent component, StatelessControllerServiceLookup lookup, String componentName, SLF4JComponentLog logger, StateManager stateManager, VariableRegistry variableRegistry, ParameterContext parameterContext) {
        this.component = Objects.requireNonNull(component);
        this.componentName = componentName == null ? "" : componentName;
        this.inputRequirement = component.getClass().getAnnotation(InputRequirement.class);
        this.lookup = lookup;
        this.stateManager = stateManager;
        this.variableRegistry = variableRegistry;
        this.identifier = component.getIdentifier();
        this.logger = logger;
        this.parameterContext = parameterContext;
    }

    public PropertyValue getProperty(PropertyDescriptor descriptor) {
        return this.getProperty(descriptor.getName());
    }

    public PropertyValue getProperty(String propertyName) {
        PropertyDescriptor descriptor = this.component.getPropertyDescriptor(propertyName);
        if (descriptor == null) {
            return null;
        }
        PropertyConfiguration setPropertyValue = this.properties.get(descriptor);
        String propValue = setPropertyValue == null ? descriptor.getDefaultValue() : setPropertyValue.getEffectiveValue(this.parameterContext);
        return new StatelessPropertyValue(propValue, this.lookup, (ParameterLookup)this.parameterContext, this.variableRegistry, this.enableExpressionValidation && this.allowExpressionValidation ? descriptor : null);
    }

    public PropertyValue newPropertyValue(String rawValue) {
        return new StatelessPropertyValue(rawValue, this.lookup, (ParameterLookup)this.parameterContext);
    }

    public ValidationResult setProperty(String propertyName, String propertyValue) {
        return this.setProperty(new PropertyDescriptor.Builder().name(propertyName).build(), propertyValue);
    }

    public ValidationResult setProperty(PropertyDescriptor descriptor, String value) {
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor can not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Cannot set property to null value; if the intent is to remove the property, call removeProperty instead");
        }
        PropertyDescriptor fullyPopulatedDescriptor = this.component.getPropertyDescriptor(descriptor.getName());
        ValidationResult result = fullyPopulatedDescriptor.validate(value, (ValidationContext)new StatelessValidationContext(this, this.lookup, this.stateManager, this.variableRegistry, this.parameterContext));
        PropertyConfiguration propertyConfiguration = this.createPropertyConfiguration(value, fullyPopulatedDescriptor.isExpressionLanguageSupported());
        PropertyConfiguration oldConfig = this.properties.put(fullyPopulatedDescriptor, propertyConfiguration);
        if (oldConfig == null) {
            oldConfig = this.createPropertyConfiguration(fullyPopulatedDescriptor.getDefaultValue(), fullyPopulatedDescriptor.isExpressionLanguageSupported());
        }
        if (value == null && oldConfig != null && oldConfig.getRawValue() != null || value != null && !value.equals(oldConfig.getRawValue())) {
            this.component.onPropertyModified(fullyPopulatedDescriptor, oldConfig.getEffectiveValue(this.parameterContext), value);
        }
        return result;
    }

    private PropertyConfiguration createPropertyConfiguration(String value, boolean supportsEl) {
        ExpressionLanguageAwareParameterParser parameterParser = supportsEl ? new ExpressionLanguageAwareParameterParser() : new ExpressionLanguageAgnosticParameterParser();
        ParameterTokenList parameterTokenList = parameterParser.parseTokens(value);
        return new PropertyConfiguration(value, parameterTokenList, parameterTokenList.toReferenceList());
    }

    public boolean removeProperty(PropertyDescriptor descriptor) {
        Objects.requireNonNull(descriptor);
        return this.removeProperty(descriptor.getName());
    }

    public boolean removeProperty(String property) {
        Objects.requireNonNull(property);
        PropertyDescriptor fullyPopulatedDescriptor = this.component.getPropertyDescriptor(property);
        PropertyConfiguration propertyConfig = this.properties.remove(fullyPopulatedDescriptor);
        if (propertyConfig != null) {
            if (!propertyConfig.getRawValue().equals(fullyPopulatedDescriptor.getDefaultValue())) {
                this.component.onPropertyModified(fullyPopulatedDescriptor, propertyConfig.getEffectiveValue(this.parameterContext), null);
            }
            return true;
        }
        return false;
    }

    public void yield() {
        this.yieldCalled = true;
    }

    public boolean isYieldCalled() {
        return this.yieldCalled;
    }

    public int getMaxConcurrentTasks() {
        return this.maxConcurrentTasks;
    }

    public ExecutionNode getExecutionNode() {
        return ExecutionNode.ALL;
    }

    public void setAnnotationData(String annotationData) {
        this.annotationData = annotationData;
    }

    public String getAnnotationData() {
        return this.annotationData;
    }

    public PropertyConfiguration getPropertyConfiguration(PropertyDescriptor propertyDescriptor) {
        return this.properties.get(propertyDescriptor);
    }

    public Map<PropertyDescriptor, String> getProperties() {
        List supported = this.component.getPropertyDescriptors();
        LinkedHashMap<PropertyDescriptor, String> effectiveValues = new LinkedHashMap<PropertyDescriptor, String>();
        for (PropertyDescriptor propertyDescriptor : supported) {
            effectiveValues.put(propertyDescriptor, null);
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            PropertyConfiguration configuration = (PropertyConfiguration)entry.getValue();
            String value = configuration.getEffectiveValue(this.parameterContext);
            effectiveValues.put(descriptor, value);
        }
        return effectiveValues;
    }

    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : this.getProperties().entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propValueMap;
    }

    public Collection<ValidationResult> validate() {
        List<ValidationResult> parameterValidationResults = this.validateParameterReferences();
        if (!parameterValidationResults.isEmpty()) {
            return parameterValidationResults;
        }
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        StatelessValidationContext validationContext = new StatelessValidationContext(this, this.lookup, this.stateManager, this.variableRegistry, this.parameterContext);
        Collection componentResults = this.component.validate((ValidationContext)validationContext);
        results.addAll(componentResults);
        Collection<ValidationResult> serviceResults = this.validateReferencedControllerServices(validationContext);
        results.addAll(serviceResults);
        for (Map.Entry<String, StatelessControllerServiceConfiguration> service : this.lookup.getControllerServices().entrySet()) {
            if (service.getValue().isEnabled()) continue;
            results.add(new ValidationResult.Builder().explanation("Controller service " + service.getKey() + " for " + this.getName() + " is not enabled").valid(false).build());
        }
        return results;
    }

    private List<ValidationResult> validateParameterReferences() {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        for (Map.Entry<PropertyDescriptor, PropertyConfiguration> entry : this.properties.entrySet()) {
            PropertyDescriptor propertyDescriptor = entry.getKey();
            PropertyConfiguration configuration = entry.getValue();
            List references = configuration.getParameterReferences();
            for (ParameterReference reference : references) {
                String parameterName = reference.getParameterName();
                Optional parameter = this.parameterContext.getParameter(parameterName);
                if (!parameter.isPresent()) {
                    results.add(new ValidationResult.Builder().subject(propertyDescriptor.getDisplayName()).valid(false).explanation("Property References Parameter '" + parameterName + "' but that Parameter is not defined in the Stateless Flow configuration").build());
                    continue;
                }
                boolean parameterSensitive = ((Parameter)parameter.get()).getDescriptor().isSensitive();
                if (parameterSensitive && !propertyDescriptor.isSensitive()) {
                    results.add(new ValidationResult.Builder().subject(propertyDescriptor.getDisplayName()).valid(false).explanation("Property References Parameter '" + parameterName + "', which is a Sensitive Parameter, but the Property is not a Sensitive Property. Sensitive Parameters may only be referenced by Sensitive Properties.").build());
                    continue;
                }
                if (parameterSensitive || !propertyDescriptor.isSensitive()) continue;
                results.add(new ValidationResult.Builder().subject(propertyDescriptor.getDisplayName()).valid(false).explanation("Property References Parameter '" + parameterName + "', which is not a Sensitive Parameter, but the Property is a Sensitive Property. Sensitive Properties may only reference Sensitive Parameters.").build());
            }
        }
        return results;
    }

    protected final Collection<ValidationResult> validateReferencedControllerServices(ValidationContext validationContext) {
        List supportedDescriptors = this.component.getPropertyDescriptors();
        if (supportedDescriptors == null) {
            return Collections.emptyList();
        }
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (PropertyDescriptor descriptor : supportedDescriptors) {
            String controllerServiceId;
            if (descriptor.getControllerServiceDefinition() == null || (controllerServiceId = validationContext.getProperty(descriptor).getValue()) == null) continue;
            ControllerService controllerService = this.lookup.getControllerService(controllerServiceId);
            if (controllerService == null) {
                ValidationResult result = new ValidationResult.Builder().valid(false).subject(descriptor.getDisplayName()).input(controllerServiceId).explanation("Invalid Controller Service: " + controllerServiceId + " is not a valid Controller Service Identifier").build();
                validationResults.add(result);
                continue;
            }
            Class requiredServiceClass = descriptor.getControllerServiceDefinition();
            if (!requiredServiceClass.isAssignableFrom(controllerService.getClass())) {
                ValidationResult result = new ValidationResult.Builder().valid(false).subject(descriptor.getDisplayName()).input(controllerServiceId).explanation("Invalid Controller Service: " + controllerServiceId + " does not implement interface " + requiredServiceClass).build();
                validationResults.add(result);
                continue;
            }
            boolean enabled = this.lookup.isControllerServiceEnabled(controllerServiceId);
            if (enabled) continue;
            validationResults.add(new ValidationResult.Builder().input(controllerServiceId).subject(descriptor.getDisplayName()).explanation("Controller Service with ID " + controllerServiceId + " is not enabled").valid(false).build());
        }
        return validationResults;
    }

    @Override
    public boolean isValid() {
        int failureCount = 0;
        for (ValidationResult result : this.validate()) {
            if (result.isValid()) continue;
            this.logger.error(result.toString());
            ++failureCount;
        }
        return failureCount == 0;
    }

    public String encrypt(String unencrypted) {
        return "enc{" + unencrypted + "}";
    }

    public String decrypt(String encrypted) {
        if (encrypted.startsWith("enc{") && encrypted.endsWith("}")) {
            return encrypted.substring(4, encrypted.length() - 2);
        }
        return encrypted;
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this.lookup;
    }

    public Set<Relationship> getAvailableRelationships() {
        if (!(this.component instanceof Processor)) {
            return Collections.emptySet();
        }
        HashSet<Relationship> relationships = new HashSet<Relationship>(((Processor)this.component).getRelationships());
        relationships.removeAll(this.unavailableRelationships);
        return relationships;
    }

    public void setUnavailableRelationships(Set<Relationship> relationships) {
        this.unavailableRelationships = Collections.unmodifiableSet(new HashSet<Relationship>(relationships));
    }

    public Set<Relationship> getUnavailableRelationships() {
        return this.unavailableRelationships;
    }

    public boolean hasIncomingConnection() {
        return this.incomingConnection;
    }

    public void setIncomingConnection(boolean hasIncomingConnection) {
        this.incomingConnection = hasIncomingConnection;
    }

    public boolean hasConnection(Relationship relationship) {
        return this.connections.contains(relationship);
    }

    public void setNonLoopConnection(boolean hasNonLoopConnection) {
        this.nonLoopConnection = hasNonLoopConnection;
    }

    public boolean hasNonLoopConnection() {
        return this.nonLoopConnection;
    }

    @Override
    public void addConnection(Relationship relationship) {
        this.connections.add(relationship);
    }

    public void removeConnection(Relationship relationship) {
        this.connections.remove(relationship);
    }

    public void setConnections(Set<Relationship> connections) {
        this.connections = connections == null ? Collections.emptySet() : Collections.unmodifiableSet(connections);
    }

    public boolean isExpressionLanguagePresent(PropertyDescriptor property) {
        if (property == null || !property.isExpressionLanguageSupported()) {
            return false;
        }
        List elRanges = Query.extractExpressionRanges((String)this.getProperty(property).getValue());
        return elRanges != null && !elRanges.isEmpty();
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public NodeTypeProvider getNodeTypeProvider() {
        return new NodeTypeProvider(){

            public boolean isClustered() {
                return false;
            }

            public boolean isPrimary() {
                return true;
            }
        };
    }

    public String getName() {
        return this.componentName;
    }

    protected void setMaxConcurrentTasks(int maxConcurrentTasks) {
        this.maxConcurrentTasks = maxConcurrentTasks;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ComponentLog getLogger() {
        return this.logger;
    }

    public String getKerberosServicePrincipal() {
        return null;
    }

    public File getKerberosServiceKeytab() {
        return null;
    }

    public File getKerberosConfigurationFile() {
        return null;
    }
}

