/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.core;

import java.util.Collections;
import java.util.Queue;
import java.util.Set;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.stateless.bootstrap.InMemoryFlowFile;
import org.apache.nifi.stateless.core.AbstractStatelessComponent;
import org.apache.nifi.stateless.core.SLF4JComponentLog;
import org.apache.nifi.stateless.core.StatelessComponent;
import org.apache.nifi.stateless.core.StatelessConnectionContext;
import org.apache.nifi.stateless.core.StatelessFlowFile;
import org.apache.nifi.stateless.core.StatelessPassThroughConnectionContext;

public class StatelessPassThroughComponent
extends AbstractStatelessComponent
implements StatelessComponent {
    static final Relationship RELATIONSHIP = new Relationship.Builder().name("").build();
    static final Set<Relationship> RELATIONSHIPS = Collections.singleton(RELATIONSHIP);
    private final StatelessConnectionContext connectionContext = new StatelessPassThroughConnectionContext();
    private final ComponentLog logger = new SLF4JComponentLog(this);

    @Override
    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @Override
    protected StatelessConnectionContext getContext() {
        return this.connectionContext;
    }

    @Override
    protected ComponentLog getLogger() {
        return this.logger;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void enqueueAll(Queue<StatelessFlowFile> list) {
        this.getChildren().get(RELATIONSHIP).forEach(child -> child.enqueueAll(list));
    }

    @Override
    public boolean runRecursive(Queue<InMemoryFlowFile> queue) {
        for (StatelessComponent component : this.getChildren().get(RELATIONSHIP)) {
            boolean success = component.runRecursive(queue);
            if (success) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isMaterializeContent() {
        return false;
    }
}

