/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.core;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.nifi.annotation.lifecycle.OnAdded;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.stateless.core.ReflectionUtils;
import org.apache.nifi.stateless.core.SLF4JComponentLog;
import org.apache.nifi.stateless.core.StatelessConfigurationContext;
import org.apache.nifi.stateless.core.StatelessControllerServiceConfiguration;
import org.apache.nifi.stateless.core.StatelessProcessContext;
import org.apache.nifi.stateless.core.StatelessStateManager;
import org.apache.nifi.stateless.core.StatelessValidationContext;

public class StatelessControllerServiceLookup
implements ControllerServiceLookup {
    private final ParameterContext parameterContext;
    private final Map<String, StatelessControllerServiceConfiguration> controllerServiceMap = new ConcurrentHashMap<String, StatelessControllerServiceConfiguration>();
    private final Map<String, SLF4JComponentLog> controllerServiceLoggers = new HashMap<String, SLF4JComponentLog>();
    private final Map<String, StatelessStateManager> controllerServiceStateManagers = new HashMap<String, StatelessStateManager>();

    public StatelessControllerServiceLookup(ParameterContext parameterContext) {
        this.parameterContext = parameterContext;
    }

    public Map<String, StatelessControllerServiceConfiguration> getControllerServices() {
        return this.controllerServiceMap;
    }

    public void addControllerService(ControllerService service, String serviceName) throws InitializationException {
        String identifier = service.getIdentifier();
        SLF4JComponentLog logger = new SLF4JComponentLog(service);
        this.controllerServiceLoggers.put(identifier, logger);
        StatelessStateManager serviceStateManager = new StatelessStateManager();
        this.controllerServiceStateManagers.put(identifier, serviceStateManager);
        StatelessProcessContext initContext = new StatelessProcessContext((ConfigurableComponent)Objects.requireNonNull(service), this, serviceName, logger, serviceStateManager, this.parameterContext);
        service.initialize((ControllerServiceInitializationContext)initContext);
        try {
            ReflectionUtils.invokeMethodsWithAnnotation(OnAdded.class, service, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new InitializationException((Throwable)e);
        }
        StatelessControllerServiceConfiguration config = new StatelessControllerServiceConfiguration(service, serviceName);
        this.controllerServiceMap.put(identifier, config);
    }

    protected StatelessControllerServiceConfiguration getConfiguration(String identifier) {
        return this.controllerServiceMap.get(identifier);
    }

    public ControllerService getControllerService(String identifier) {
        StatelessControllerServiceConfiguration status = this.controllerServiceMap.get(identifier);
        return status == null ? null : status.getService();
    }

    public boolean isControllerServiceEnabled(String serviceIdentifier) {
        StatelessControllerServiceConfiguration status = this.controllerServiceMap.get(serviceIdentifier);
        if (status == null) {
            throw new IllegalArgumentException("No ControllerService exists with identifier " + serviceIdentifier);
        }
        return status.isEnabled();
    }

    public boolean isControllerServiceEnabled(ControllerService service) {
        return this.isControllerServiceEnabled(service.getIdentifier());
    }

    public boolean isControllerServiceEnabling(String serviceIdentifier) {
        return false;
    }

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType) {
        HashSet<String> ids = new HashSet<String>();
        for (Map.Entry<String, StatelessControllerServiceConfiguration> entry : this.controllerServiceMap.entrySet()) {
            if (!serviceType.isAssignableFrom(entry.getValue().getService().getClass())) continue;
            ids.add(entry.getKey());
        }
        return ids;
    }

    public String getControllerServiceName(String serviceIdentifier) {
        StatelessControllerServiceConfiguration status = this.controllerServiceMap.get(serviceIdentifier);
        return status == null ? null : serviceIdentifier;
    }

    public void enableControllerServices(VariableRegistry variableRegistry) {
        for (StatelessControllerServiceConfiguration config : this.controllerServiceMap.values()) {
            ControllerService service = config.getService();
            Collection<ValidationResult> validationResults = this.validate(service, config.getName(), variableRegistry);
            if (!validationResults.isEmpty()) {
                throw new RuntimeException("Failed to enable Controller Service {id=" + service.getIdentifier() + ", name=" + config.getName() + ", type=" + service.getClass() + "} because validation failed: " + validationResults);
            }
            try {
                this.enableControllerService(service, variableRegistry);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Failed to enable Controller Service {id=" + service.getIdentifier() + ", name=" + config.getName() + ", type=" + service.getClass() + "}", e);
            }
        }
    }

    public Collection<ValidationResult> validate(ControllerService service, String serviceName, VariableRegistry variableRegistry) {
        StateManager stateManager = this.controllerServiceStateManagers.get(service.getIdentifier());
        SLF4JComponentLog logger = this.controllerServiceLoggers.get(service.getIdentifier());
        StatelessProcessContext processContext = new StatelessProcessContext((ConfigurableComponent)service, this, serviceName, logger, stateManager, variableRegistry, this.parameterContext);
        StatelessValidationContext validationContext = new StatelessValidationContext(processContext, this, stateManager, variableRegistry, this.parameterContext);
        return service.validate((ValidationContext)validationContext);
    }

    private void enableControllerService(ControllerService service, VariableRegistry registry) throws InvocationTargetException, IllegalAccessException {
        StatelessControllerServiceConfiguration configuration = this.getConfiguration(service.getIdentifier());
        if (configuration == null) {
            throw new IllegalArgumentException("Controller Service " + service + " is not known");
        }
        if (configuration.isEnabled()) {
            throw new IllegalStateException("Cannot enable Controller Service " + service + " because it is not disabled");
        }
        StatelessConfigurationContext configContext = new StatelessConfigurationContext(service, configuration.getProperties(), this, registry, (ParameterLookup)this.parameterContext);
        ReflectionUtils.invokeMethodsWithAnnotation(OnEnabled.class, service, configContext);
        configuration.setEnabled(true);
    }

    public void setControllerServiceAnnotationData(ControllerService service, String annotationData) {
        StatelessControllerServiceConfiguration configuration = this.getControllerServiceConfigToUpdate(service);
        configuration.setAnnotationData(annotationData);
    }

    private StatelessControllerServiceConfiguration getControllerServiceConfigToUpdate(ControllerService service) {
        StatelessControllerServiceConfiguration configuration = this.getConfiguration(service.getIdentifier());
        if (configuration == null) {
            throw new IllegalArgumentException("Controller Service " + service + " is not known");
        }
        if (configuration.isEnabled()) {
            throw new IllegalStateException("Controller service " + service + " cannot be modified because it is not disabled");
        }
        return configuration;
    }

    public ValidationResult setControllerServiceProperty(ControllerService service, PropertyDescriptor property, StatelessProcessContext context, VariableRegistry registry, String value) {
        StatelessStateManager serviceStateManager = this.controllerServiceStateManagers.get(service.getIdentifier());
        if (serviceStateManager == null) {
            throw new IllegalStateException("Controller service " + service + " has not been added to this TestRunner via the #addControllerService method");
        }
        ValidationContext validationContext = new StatelessValidationContext(context, this, serviceStateManager, registry, this.parameterContext).getControllerServiceValidationContext(service);
        ValidationResult validationResult = property.validate(value, validationContext);
        StatelessControllerServiceConfiguration configuration = this.getControllerServiceConfigToUpdate(service);
        String oldValue = configuration.getProperties().get(property);
        configuration.setProperty(property, value);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            service.onPropertyModified(property, oldValue, value);
        }
        return validationResult;
    }
}

