/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.core;

import java.io.File;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.stateless.core.SLF4JComponentLog;

public class StatelessControllerServiceInitializationContext
implements ControllerServiceInitializationContext {
    private final ComponentLog logger;
    private final String processorId;
    private final ControllerServiceLookup controllerServiceLookup;
    private final StateManager stateManager;

    public StatelessControllerServiceInitializationContext(String id, ControllerService controllerService, ControllerServiceLookup serviceLookup, StateManager stateManager) {
        this.processorId = id;
        this.logger = new SLF4JComponentLog(controllerService);
        this.controllerServiceLookup = serviceLookup;
        this.stateManager = stateManager;
    }

    public String getIdentifier() {
        return this.processorId;
    }

    public ComponentLog getLogger() {
        return this.logger;
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this.controllerServiceLookup;
    }

    public NodeTypeProvider getNodeTypeProvider() {
        return new NodeTypeProvider(){

            public boolean isClustered() {
                return false;
            }

            public boolean isPrimary() {
                return false;
            }
        };
    }

    public String getKerberosServicePrincipal() {
        return null;
    }

    public File getKerberosServiceKeytab() {
        return null;
    }

    public File getKerberosConfigurationFile() {
        return null;
    }
}

