/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.core;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.registry.client.FlowClient;
import org.apache.nifi.registry.client.FlowSnapshotClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryClientConfig;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.client.impl.JerseyNiFiRegistryClient;
import org.apache.nifi.registry.flow.VersionedFlowCoordinates;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.registry.flow.VersionedProcessGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryUtil {
    private static final Logger logger = LoggerFactory.getLogger(RegistryUtil.class);
    private final String registryUrl;
    private NiFiRegistryClient registryClient;
    private final SSLContext sslContext;

    public RegistryUtil(String registryUrl, SSLContext sslContext) {
        this.registryUrl = registryUrl;
        this.sslContext = sslContext;
    }

    public VersionedFlowSnapshot getFlowByID(String bucketID, String flowID) throws IOException, NiFiRegistryException {
        return this.getFlowByID(bucketID, flowID, -1);
    }

    public VersionedFlowSnapshot getFlowByID(String bucketID, String flowID, int versionID) throws IOException, NiFiRegistryException {
        if (versionID == -1) {
            versionID = this.getLatestVersion(bucketID, flowID, null);
        }
        logger.debug("Fetching flow Bucket={}, Flow={}, Version={}, FetchRemoteFlows=true", new Object[]{bucketID, flowID, versionID});
        long start = System.nanoTime();
        VersionedFlowSnapshot snapshot = this.getFlowContents(bucketID, flowID, versionID, true, null);
        long millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        logger.info("Successfully fetched flow from registry in {} millis", (Object)millis);
        return snapshot;
    }

    private int getLatestVersion(String bucketId, String flowId, NiFiUser user) throws IOException, NiFiRegistryException {
        return (int)this.getFlowClient(user).get(bucketId, flowId).getVersionCount();
    }

    private FlowClient getFlowClient(NiFiUser user) {
        String identity = this.getIdentity(user);
        NiFiRegistryClient registryClient = this.getRegistryClient();
        FlowClient flowClient = identity == null ? registryClient.getFlowClient() : registryClient.getFlowClient(new String[]{identity});
        return flowClient;
    }

    private FlowSnapshotClient getFlowSnapshotClient(NiFiUser user) {
        String identity = this.getIdentity(user);
        NiFiRegistryClient registryClient = this.getRegistryClient();
        FlowSnapshotClient snapshotClient = identity == null ? registryClient.getFlowSnapshotClient() : registryClient.getFlowSnapshotClient(new String[]{identity});
        return snapshotClient;
    }

    private synchronized NiFiRegistryClient getRegistryClient() {
        if (this.registryClient != null) {
            return this.registryClient;
        }
        NiFiRegistryClientConfig config = new NiFiRegistryClientConfig.Builder().connectTimeout(Integer.valueOf(30000)).readTimeout(Integer.valueOf(30000)).sslContext(this.sslContext).baseUrl(this.registryUrl).build();
        this.registryClient = new JerseyNiFiRegistryClient.Builder().config(config).build();
        return this.registryClient;
    }

    private String getIdentity(NiFiUser user) {
        return user == null || user.isAnonymous() ? null : user.getIdentity();
    }

    public VersionedFlowSnapshot getFlowContents(String bucketId, String flowId, int version, boolean fetchRemoteFlows, NiFiUser user) throws IOException, NiFiRegistryException {
        FlowSnapshotClient snapshotClient = this.getFlowSnapshotClient(user);
        VersionedFlowSnapshot flowSnapshot = snapshotClient.get(bucketId, flowId, version);
        if (fetchRemoteFlows) {
            VersionedProcessGroup contents = flowSnapshot.getFlowContents();
            for (VersionedProcessGroup child : contents.getProcessGroups()) {
                this.populateVersionedContentsRecursively(child, user);
            }
        }
        return flowSnapshot;
    }

    private void populateVersionedContentsRecursively(VersionedProcessGroup group, NiFiUser user) throws NiFiRegistryException, IOException {
        if (group == null) {
            return;
        }
        VersionedFlowCoordinates coordinates = group.getVersionedFlowCoordinates();
        if (coordinates != null) {
            String registryUrl = coordinates.getRegistryUrl();
            String bucketId = coordinates.getBucketId();
            String flowId = coordinates.getFlowId();
            int version = coordinates.getVersion();
            RegistryUtil subFlowUtil = new RegistryUtil(registryUrl, this.sslContext);
            VersionedFlowSnapshot snapshot = subFlowUtil.getFlowByID(bucketId, flowId, version);
            VersionedProcessGroup contents = snapshot.getFlowContents();
            group.setComments(contents.getComments());
            group.setConnections(contents.getConnections());
            group.setControllerServices(contents.getControllerServices());
            group.setFunnels(contents.getFunnels());
            group.setInputPorts(contents.getInputPorts());
            group.setLabels(contents.getLabels());
            group.setOutputPorts(contents.getOutputPorts());
            group.setProcessGroups(contents.getProcessGroups());
            group.setProcessors(contents.getProcessors());
            group.setRemoteProcessGroups(contents.getRemoteProcessGroups());
            group.setVariables(contents.getVariables());
            coordinates.setLatest(Boolean.valueOf(snapshot.isLatest()));
        }
        for (VersionedProcessGroup child : group.getProcessGroups()) {
            this.populateVersionedContentsRecursively(child, user);
        }
    }
}

