/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.stateless.core.StatelessComponent;
import org.apache.nifi.stateless.core.StatelessConnectionContext;

public abstract class AbstractStatelessComponent
implements StatelessComponent {
    private List<StatelessComponent> parents = new ArrayList<StatelessComponent>();
    private List<String> incomingConnections = new ArrayList<String>();
    private final Map<Relationship, List<StatelessComponent>> children = new HashMap<Relationship, List<StatelessComponent>>();
    private final Set<Relationship> autoTermination = new HashSet<Relationship>();
    private final Set<Relationship> successOutputPorts = new HashSet<Relationship>();
    private final Set<Relationship> failureOutputPorts = new HashSet<Relationship>();

    @Override
    public List<StatelessComponent> getParents() {
        return Collections.unmodifiableList(this.parents);
    }

    @Override
    public void addParent(StatelessComponent parent) {
        if (parent != null) {
            this.parents.add(parent);
        }
    }

    @Override
    public void addIncomingConnection(String connectionId) {
        this.incomingConnections.add(connectionId);
    }

    @Override
    public void addOutputPort(Relationship relationship, boolean isFailurePort) {
        if (isFailurePort) {
            this.failureOutputPorts.add(relationship);
        } else {
            this.successOutputPorts.add(relationship);
        }
    }

    @Override
    public void addChild(StatelessComponent child, Relationship relationship) {
        List list = this.children.computeIfAbsent(relationship, r -> new ArrayList());
        list.add(child);
        this.getContext().addConnection(relationship);
    }

    public void addAutoTermination(Relationship relationship) {
        this.autoTermination.add(relationship);
        this.getContext().addConnection(relationship);
    }

    @Override
    public boolean validate() {
        if (!this.getContext().isValid()) {
            return false;
        }
        for (Relationship relationship : this.getRelationships()) {
            boolean hasChildren = this.children.containsKey(relationship);
            boolean hasAutoterminate = this.autoTermination.contains(relationship);
            boolean hasFailureOutputPort = this.failureOutputPorts.contains(relationship);
            boolean hasSuccessOutputPort = this.successOutputPorts.contains(relationship);
            if (hasChildren || hasAutoterminate || hasFailureOutputPort || hasSuccessOutputPort) continue;
            this.getLogger().error("Component: {}, Relationship: {}, either needs to be auto-terminated or connected to another component", new Object[]{this.toString(), relationship.getName()});
            return false;
        }
        for (Map.Entry entry : this.children.entrySet()) {
            for (StatelessComponent component : (List)entry.getValue()) {
                if (component.validate()) continue;
                return false;
            }
        }
        return true;
    }

    protected Map<Relationship, List<StatelessComponent>> getChildren() {
        return this.children;
    }

    protected Set<Relationship> getSuccessOutputPorts() {
        return this.successOutputPorts;
    }

    protected Set<Relationship> getFailureOutputPorts() {
        return this.failureOutputPorts;
    }

    protected boolean isAutoTerminated(Relationship relationship) {
        return this.autoTermination.contains(relationship);
    }

    public abstract Set<Relationship> getRelationships();

    protected abstract StatelessConnectionContext getContext();

    protected abstract ComponentLog getLogger();
}

