/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.flow;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.exception.TerminatedTaskException;
import org.apache.nifi.stateless.flow.TriggerResult;

public class ExceptionalTriggerResult
implements TriggerResult {
    private final Throwable failureCause;

    public ExceptionalTriggerResult(Throwable failureCause) {
        this.failureCause = failureCause;
    }

    public boolean isSuccessful() {
        return false;
    }

    public boolean isCanceled() {
        return this.failureCause instanceof TerminatedTaskException;
    }

    public Optional<Throwable> getFailureCause() {
        return Optional.ofNullable(this.failureCause);
    }

    public Map<String, List<FlowFile>> getOutputFlowFiles() {
        return Collections.emptyMap();
    }

    public List<FlowFile> getOutputFlowFiles(String portName) {
        return Collections.emptyList();
    }

    public InputStream readContent(FlowFile flowFile) {
        throw new IllegalArgumentException("Unknown FlowFile: " + String.valueOf(flowFile));
    }

    public byte[] readContentAsByteArray(FlowFile flowFile) throws IOException {
        throw new IllegalArgumentException("Unknown FlowFile: " + String.valueOf(flowFile));
    }

    public void acknowledge() {
    }

    public void abort(Throwable cause) {
        if (cause != null && this.failureCause != cause) {
            this.failureCause.addSuppressed(cause);
        }
    }
}

