/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.engine;

import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.components.validation.VerifiableComponentFactory;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.VerifiableControllerService;
import org.apache.nifi.controller.exception.ControllerServiceInstantiationException;
import org.apache.nifi.controller.exception.ProcessorInstantiationException;
import org.apache.nifi.controller.kerberos.KerberosConfig;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.StandardControllerServiceInitializationContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.StandardProcessorInitializationContext;
import org.apache.nifi.processor.VerifiableProcessor;
import org.apache.nifi.stateless.engine.StatelessNodeTypeProvider;

public class StatelessVerifiableComponentFactory
implements VerifiableComponentFactory {
    private final StateManagerProvider stateManagerProvider;
    private final ControllerServiceProvider controllerServiceProvider;
    private final KerberosConfig kerberosConfig;

    public StatelessVerifiableComponentFactory(StateManagerProvider stateManagerProvider, ControllerServiceProvider controllerServiceProvider, KerberosConfig kerberosConfig) {
        this.stateManagerProvider = stateManagerProvider;
        this.controllerServiceProvider = controllerServiceProvider;
        this.kerberosConfig = kerberosConfig;
    }

    public VerifiableProcessor createProcessor(ProcessorNode processorNode, ClassLoader classLoader) throws ProcessorInstantiationException {
        VerifiableProcessor verifiableProcessor;
        String identifier = processorNode.getIdentifier();
        String processorClassName = processorNode.getProcessor().getClass().getName();
        try {
            Class<?> rawProcessorClass = Class.forName(processorClassName, true, classLoader);
            Class<VerifiableProcessor> processorClass = rawProcessorClass.asSubclass(VerifiableProcessor.class);
            verifiableProcessor = processorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            StandardProcessorInitializationContext tempInitializationContext = new StandardProcessorInitializationContext(identifier, (ComponentLog)processorNode.getLogger(), this.controllerServiceProvider, (NodeTypeProvider)new StatelessNodeTypeProvider(), this.kerberosConfig);
            if (verifiableProcessor instanceof Processor) {
                Processor processor = (Processor)verifiableProcessor;
                processor.initialize((ProcessorInitializationContext)tempInitializationContext);
            }
        }
        catch (Exception e) {
            throw new ProcessorInstantiationException("Failed to instantiate Verifiable Processor Class [%s]".formatted(processorClassName), (Throwable)e);
        }
        return verifiableProcessor;
    }

    public VerifiableControllerService createControllerService(ControllerServiceNode serviceNode, ClassLoader classLoader) {
        VerifiableControllerService verifiableControllerService;
        String identifier = serviceNode.getIdentifier();
        String controllerServiceClassName = serviceNode.getCanonicalClassName();
        try {
            Class<?> rawControllorServiceClass = Class.forName(controllerServiceClassName, true, classLoader);
            Class<VerifiableControllerService> controllerServiceClass = rawControllorServiceClass.asSubclass(VerifiableControllerService.class);
            verifiableControllerService = controllerServiceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            StandardControllerServiceInitializationContext tempInitializationContext = new StandardControllerServiceInitializationContext(identifier, (ComponentLog)serviceNode.getLogger(), this.controllerServiceProvider, this.stateManagerProvider.getStateManager(identifier), this.kerberosConfig, (NodeTypeProvider)new StatelessNodeTypeProvider());
            if (verifiableControllerService instanceof ControllerService) {
                ControllerService controllerService = (ControllerService)verifiableControllerService;
                controllerService.initialize((ControllerServiceInitializationContext)tempInitializationContext);
            }
        }
        catch (Exception e) {
            throw new ControllerServiceInstantiationException("Failed to instantiate Verifiable Controller Service Class [%s]".formatted(controllerServiceClassName), (Throwable)e);
        }
        return verifiableControllerService;
    }
}

