/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.repository;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ContentClaimWriteCache;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.metrics.PerformanceTracker;
import org.apache.nifi.controller.repository.metrics.PerformanceTrackingOutputStream;
import org.apache.nifi.processor.exception.ProcessException;

public class StatelessContentClaimWriteCache
implements ContentClaimWriteCache {
    private final ContentRepository contentRepository;
    private final PerformanceTracker performanceTracker;
    private final List<OutputStream> writtenTo = new ArrayList<OutputStream>();

    public StatelessContentClaimWriteCache(ContentRepository contentRepository, PerformanceTracker performanceTracker) {
        this.contentRepository = contentRepository;
        this.performanceTracker = performanceTracker;
    }

    public void reset() {
        for (OutputStream stream : this.writtenTo) {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new ProcessException("Failed to close OutputStream", (Throwable)e);
            }
        }
        this.writtenTo.clear();
    }

    public ContentClaim getContentClaim() throws IOException {
        return this.contentRepository.create(false);
    }

    public OutputStream write(ContentClaim claim) throws IOException {
        OutputStream rawOut = this.contentRepository.write(claim);
        PerformanceTrackingOutputStream out = new PerformanceTrackingOutputStream(rawOut, this.performanceTracker);
        this.writtenTo.add((OutputStream)out);
        return out;
    }

    public void flush(ContentClaim contentClaim) {
    }

    public void flush(ResourceClaim claim) {
    }

    public void flush() {
    }
}

