/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.flow;

import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.stateless.flow.TransactionThresholds;

public class TransactionThresholdMeter {
    private final TransactionThresholds thresholds;
    private long startNanos;
    private long bytes;
    private long flowFiles;

    public TransactionThresholdMeter(TransactionThresholds thresholds) {
        this.thresholds = thresholds;
    }

    public void reset() {
        this.startNanos = System.nanoTime();
        this.bytes = 0L;
        this.flowFiles = 0L;
    }

    public TransactionThresholds getThresholds() {
        return this.thresholds;
    }

    public void incrementFlowFiles(long flowFiles) {
        this.flowFiles += flowFiles;
    }

    public void incrementBytes(long bytes) {
        this.bytes += bytes;
    }

    public boolean isThresholdMet() {
        OptionalLong maxFlowFiles = this.thresholds.getMaxFlowFiles();
        if (maxFlowFiles.isPresent() && this.flowFiles >= maxFlowFiles.getAsLong()) {
            return true;
        }
        OptionalLong maxBytes = this.thresholds.getMaxContentSize(DataUnit.B);
        if (maxBytes.isPresent() && this.bytes >= maxBytes.getAsLong()) {
            return true;
        }
        OptionalLong maxNanos = this.thresholds.getMaxTime(TimeUnit.NANOSECONDS);
        if (maxNanos.isPresent()) {
            long now = System.nanoTime();
            long nanosSinceStart = now - this.startNanos;
            return nanosSinceStart >= maxNanos.getAsLong();
        }
        return false;
    }

    public String toString() {
        long millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startNanos);
        return "TransactionThresholdMeter[flowFiles=" + this.flowFiles + ", bytes=" + this.bytes + ", elapsedTime=" + millis + " millis]";
    }
}

