/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.nifi.flow.VersionedExternalFlow;
import org.apache.nifi.flow.VersionedExternalFlowMetadata;
import org.apache.nifi.registry.flow.AbstractFlowRegistryClient;
import org.apache.nifi.registry.flow.BucketLocation;
import org.apache.nifi.registry.flow.FlowLocation;
import org.apache.nifi.registry.flow.FlowRegistryBucket;
import org.apache.nifi.registry.flow.FlowRegistryClient;
import org.apache.nifi.registry.flow.FlowRegistryClientConfigurationContext;
import org.apache.nifi.registry.flow.FlowRegistryException;
import org.apache.nifi.registry.flow.FlowVersionLocation;
import org.apache.nifi.registry.flow.RegisterAction;
import org.apache.nifi.registry.flow.RegisteredFlow;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshot;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshotMetadata;

public class InMemoryFlowRegistry
extends AbstractFlowRegistryClient
implements FlowRegistryClient {
    private static final String USER_SPECIFIC_ACTIONS_NOT_SUPPORTED = "User-specific actions are not implemented with this Registry";
    private final AtomicInteger flowIdGenerator = new AtomicInteger(1);
    private static final String DEFAULT_BUCKET_ID = "stateless-bucket-1";
    private final Map<FlowCoordinates, List<VersionedExternalFlow>> flowSnapshots = new ConcurrentHashMap<FlowCoordinates, List<VersionedExternalFlow>>();

    public boolean isStorageLocationApplicable(FlowRegistryClientConfigurationContext context, String location) {
        return true;
    }

    public Set<FlowRegistryBucket> getBuckets(FlowRegistryClientConfigurationContext context, String branch) {
        throw new UnsupportedOperationException(USER_SPECIFIC_ACTIONS_NOT_SUPPORTED);
    }

    public FlowRegistryBucket getBucket(FlowRegistryClientConfigurationContext context, BucketLocation bucketLocation) {
        throw new UnsupportedOperationException(USER_SPECIFIC_ACTIONS_NOT_SUPPORTED);
    }

    public RegisteredFlow registerFlow(FlowRegistryClientConfigurationContext context, RegisteredFlow flow) {
        throw new UnsupportedOperationException(USER_SPECIFIC_ACTIONS_NOT_SUPPORTED);
    }

    public RegisteredFlow deregisterFlow(FlowRegistryClientConfigurationContext context, FlowLocation flowLocation) {
        throw new UnsupportedOperationException(USER_SPECIFIC_ACTIONS_NOT_SUPPORTED);
    }

    public Set<RegisteredFlow> getFlows(FlowRegistryClientConfigurationContext context, BucketLocation bucketLocation) {
        throw new UnsupportedOperationException(USER_SPECIFIC_ACTIONS_NOT_SUPPORTED);
    }

    public RegisteredFlowSnapshot registerFlowSnapshot(FlowRegistryClientConfigurationContext context, RegisteredFlowSnapshot flowSnapshot, RegisterAction registerAction) {
        throw new UnsupportedOperationException(USER_SPECIFIC_ACTIONS_NOT_SUPPORTED);
    }

    public RegisteredFlow getFlow(FlowRegistryClientConfigurationContext context, FlowLocation flowLocation) {
        String bucketId = flowLocation.getBucketId();
        String flowId = flowLocation.getFlowId();
        FlowCoordinates flowCoordinates = new FlowCoordinates(bucketId, flowId);
        List<VersionedExternalFlow> snapshots = this.flowSnapshots.get(flowCoordinates);
        RegisteredFlow versionedFlow = new RegisteredFlow();
        versionedFlow.setBucketIdentifier(bucketId);
        versionedFlow.setBucketName(bucketId);
        versionedFlow.setDescription("Stateless Flow");
        versionedFlow.setIdentifier(flowId);
        versionedFlow.setName(flowId);
        versionedFlow.setVersionCount((long)snapshots.size());
        return versionedFlow;
    }

    public RegisteredFlowSnapshot getFlowContents(FlowRegistryClientConfigurationContext context, FlowVersionLocation flowVersionLocation) throws FlowRegistryException {
        if (context.getNiFiUserIdentity().isPresent()) {
            throw new UnsupportedOperationException(USER_SPECIFIC_ACTIONS_NOT_SUPPORTED);
        }
        String bucketId = flowVersionLocation.getBucketId();
        String flowId = flowVersionLocation.getFlowId();
        String version = flowVersionLocation.getVersion();
        FlowCoordinates flowCoordinates = new FlowCoordinates(bucketId, flowId);
        List<VersionedExternalFlow> snapshots = this.flowSnapshots.get(flowCoordinates);
        VersionedExternalFlow registeredFlowSnapshot = snapshots.stream().filter(snapshot -> Objects.equals(snapshot.getMetadata().getVersion(), version)).findAny().orElseThrow(() -> new FlowRegistryException("Could not find flow: bucketId=" + bucketId + ", flowId=" + flowId + ", version=" + version));
        return this.convertToRegisteredFlowSnapshot(registeredFlowSnapshot);
    }

    private RegisteredFlowSnapshot convertToRegisteredFlowSnapshot(VersionedExternalFlow externalFlow) {
        VersionedExternalFlowMetadata externalFlowMetadata = externalFlow.getMetadata();
        RegisteredFlowSnapshotMetadata snapshotMetadata = new RegisteredFlowSnapshotMetadata();
        snapshotMetadata.setBucketIdentifier(externalFlowMetadata.getBucketIdentifier());
        snapshotMetadata.setVersion(externalFlowMetadata.getVersion());
        snapshotMetadata.setFlowIdentifier(externalFlowMetadata.getFlowIdentifier());
        RegisteredFlow versionedFlow = new RegisteredFlow();
        versionedFlow.setName(externalFlowMetadata.getFlowName());
        versionedFlow.setIdentifier(externalFlowMetadata.getFlowIdentifier());
        versionedFlow.setBucketIdentifier(externalFlowMetadata.getBucketIdentifier());
        RegisteredFlowSnapshot flowSnapshot = new RegisteredFlowSnapshot();
        flowSnapshot.setExternalControllerServices(externalFlow.getExternalControllerServices());
        flowSnapshot.setFlowContents(externalFlow.getFlowContents());
        flowSnapshot.setParameterContexts(externalFlow.getParameterContexts());
        flowSnapshot.setSnapshotMetadata(snapshotMetadata);
        flowSnapshot.setFlow(versionedFlow);
        return flowSnapshot;
    }

    public synchronized void addFlowSnapshot(VersionedExternalFlow versionedExternalFlow) {
        String version;
        Object flowId;
        String bucketId;
        VersionedExternalFlowMetadata metadata = versionedExternalFlow.getMetadata();
        if (metadata == null) {
            bucketId = DEFAULT_BUCKET_ID;
            flowId = "flow-" + this.flowIdGenerator.getAndIncrement();
            version = "1";
        } else {
            bucketId = metadata.getBucketIdentifier();
            flowId = metadata.getFlowIdentifier();
            version = metadata.getVersion();
        }
        FlowCoordinates coordinates = new FlowCoordinates(bucketId, (String)flowId);
        List snapshots = this.flowSnapshots.computeIfAbsent(coordinates, key -> Collections.synchronizedList(new ArrayList()));
        Optional<VersionedExternalFlow> optionalSnapshot = snapshots.stream().filter(snapshot -> snapshot.getMetadata().getVersion() == version).findAny();
        if (optionalSnapshot.isPresent()) {
            throw new IllegalStateException("Versioned Flow Snapshot already exists for bucketId=" + bucketId + ", flowId=" + (String)flowId + ", version=" + version);
        }
        snapshots.add(versionedExternalFlow);
    }

    public Set<RegisteredFlowSnapshotMetadata> getFlowVersions(FlowRegistryClientConfigurationContext context, FlowLocation flowLocation) {
        throw new UnsupportedOperationException(USER_SPECIFIC_ACTIONS_NOT_SUPPORTED);
    }

    public Optional<String> getLatestVersion(FlowRegistryClientConfigurationContext context, FlowLocation flowLocation) {
        throw new UnsupportedOperationException(USER_SPECIFIC_ACTIONS_NOT_SUPPORTED);
    }

    private static class FlowCoordinates {
        private final String bucketId;
        private final String flowId;

        public FlowCoordinates(String bucketId, String flowId) {
            this.bucketId = bucketId;
            this.flowId = flowId;
        }

        public String getBucketId() {
            return this.bucketId;
        }

        public String getFlowId() {
            return this.flowId;
        }
    }
}

