/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.extensions;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.extensions.ExtensionClient;
import org.apache.nifi.stateless.config.SslConfigurationUtil;
import org.apache.nifi.stateless.config.SslContextDefinition;
import org.apache.nifi.stateless.config.StatelessConfigurationException;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.web.client.StandardWebClientService;
import org.apache.nifi.web.client.api.HttpResponseEntity;
import org.apache.nifi.web.client.api.WebClientService;
import org.apache.nifi.web.client.redirect.RedirectHandling;
import org.apache.nifi.web.client.ssl.TlsContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NexusExtensionClient
implements ExtensionClient {
    private static final Logger logger = LoggerFactory.getLogger(NexusExtensionClient.class);
    private static final long DEFAULT_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    private static final Charset URL_CHARSET = StandardCharsets.UTF_8;
    private final String baseUrl;
    private final long timeoutMillis;
    private final SslContextDefinition sslContextDefinition;

    public NexusExtensionClient(String baseUrl, SslContextDefinition sslContextDefinition, String timeout) {
        this.baseUrl = baseUrl;
        this.sslContextDefinition = sslContextDefinition;
        this.timeoutMillis = timeout == null ? DEFAULT_TIMEOUT_MILLIS : FormatUtils.getTimeDuration((String)timeout, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Override
    public InputStream getExtension(BundleCoordinate bundleCoordinate) throws IOException {
        String url = this.resolveUrl(bundleCoordinate);
        logger.debug("Attempting to fetch {} from {}", (Object)bundleCoordinate, (Object)url);
        WebClientService webClientService = this.getWebClientService();
        URI uri = URI.create(url);
        final HttpResponseEntity responseEntity = webClientService.get().uri(uri).retrieve();
        int statusCode = responseEntity.statusCode();
        if (statusCode == 200) {
            logger.debug("Successfully obtained stream for extension {} from {}", (Object)bundleCoordinate, (Object)url);
            InputStream extensionByteStream = responseEntity.body();
            return new FilterInputStream(this, extensionByteStream){

                @Override
                public void close() throws IOException {
                    responseEntity.close();
                    super.close();
                }
            };
        }
        try {
            if (statusCode == 404) {
                logger.debug("Received NOT FOUND response for extension {} from {}", (Object)bundleCoordinate, (Object)url);
                InputStream extensionByteStream = null;
                return extensionByteStream;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            InputStream body = responseEntity.body();
            body.transferTo(outputStream);
            String responseBody = outputStream.toString();
            String message = "Failed to fetch extension %s from [%s] HTTP %d %s".formatted(bundleCoordinate, url, statusCode, responseBody);
            throw new IOException(message);
        }
        finally {
            responseEntity.close();
        }
    }

    private WebClientService getWebClientService() throws IOException {
        StandardWebClientService webClientService = new StandardWebClientService();
        Duration timeout = Duration.ofMillis(this.timeoutMillis);
        webClientService.setConnectTimeout(timeout);
        webClientService.setReadTimeout(timeout);
        webClientService.setRedirectHandling(RedirectHandling.FOLLOWED);
        if (this.sslContextDefinition != null) {
            try {
                TlsContext tlsContext = SslConfigurationUtil.createTlsContext(this.sslContextDefinition);
                webClientService.setTlsContext(tlsContext);
            }
            catch (StatelessConfigurationException e) {
                throw new IOException("Web Client Service TLS Configuration failed", e);
            }
        }
        return webClientService;
    }

    private String resolveUrl(BundleCoordinate bundleCoordinate) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder(this.baseUrl);
        if (!this.baseUrl.endsWith("/")) {
            sb.append("/");
        }
        String artifactPath = URLEncoder.encode(bundleCoordinate.getId(), URL_CHARSET);
        String versionPath = URLEncoder.encode(bundleCoordinate.getVersion(), URL_CHARSET);
        sb.append(URLEncoder.encode(bundleCoordinate.getGroup(), URL_CHARSET).replace(".", "/"));
        sb.append("/");
        sb.append(artifactPath);
        sb.append("/");
        sb.append(versionPath);
        sb.append("/");
        sb.append(artifactPath).append("-").append(versionPath);
        sb.append(".nar");
        return sb.toString();
    }

    public String toString() {
        return "NexusExtensionClient[baseUrl=" + this.baseUrl + "]";
    }
}

