/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.engine;

import java.net.URL;
import java.util.Set;
import org.apache.nifi.annotation.lifecycle.OnRemoved;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.FlowAnalysisRuleNode;
import org.apache.nifi.controller.LoggableComponent;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.controller.ParameterProviderNode;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.TerminationAwareLogger;
import org.apache.nifi.controller.exception.ControllerServiceInstantiationException;
import org.apache.nifi.controller.exception.ProcessorInstantiationException;
import org.apache.nifi.controller.flowanalysis.FlowAnalysisRuleInstantiationException;
import org.apache.nifi.controller.flowrepository.FlowRepositoryClientInstantiationException;
import org.apache.nifi.controller.service.ControllerServiceInvocationHandler;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.GroupedComponent;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.logging.LoggingContext;
import org.apache.nifi.logging.StandardLoggingContext;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.InstanceClassLoader;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.processor.StandardProcessContext;
import org.apache.nifi.registry.flow.FlowRegistryClientNode;
import org.apache.nifi.stateless.engine.StatelessEngine;
import org.apache.nifi.stateless.engine.StatelessNodeTypeProvider;
import org.apache.nifi.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatelessReloadComponent
implements ReloadComponent {
    private static final Logger logger = LoggerFactory.getLogger(StatelessReloadComponent.class);
    private final StatelessEngine statelessEngine;

    public StatelessReloadComponent(StatelessEngine statelessEngine) {
        this.statelessEngine = statelessEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(ProcessorNode existingNode, String newType, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls) throws ProcessorInstantiationException {
        if (existingNode == null) {
            throw new IllegalStateException("Existing ProcessorNode cannot be null");
        }
        String id = existingNode.getProcessor().getIdentifier();
        logger.debug("Reloading component {} to type {} from bundle {}", new Object[]{id, newType, bundleCoordinate});
        ExtensionManager extensionManager = this.statelessEngine.getExtensionManager();
        InstanceClassLoader existingInstanceClassLoader = extensionManager.getInstanceClassLoader(id);
        ProcessorNode newNode = this.statelessEngine.getFlowManager().createProcessor(newType, id, bundleCoordinate, additionalUrls, true, false, null);
        try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ClassLoader)existingInstanceClassLoader);){
            Class componentClass = existingNode.getProcessor() == null ? null : existingNode.getProcessor().getClass();
            StateManager stateManager = this.statelessEngine.getStateManagerProvider().getStateManager(id, componentClass);
            StandardProcessContext processContext = new StandardProcessContext(existingNode, this.statelessEngine.getControllerServiceProvider(), stateManager, () -> false, (NodeTypeProvider)new StatelessNodeTypeProvider());
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)existingNode.getProcessor(), (Object[])new Object[]{processContext});
        }
        finally {
            extensionManager.closeURLClassLoader(id, (ClassLoader)existingInstanceClassLoader);
        }
        SimpleProcessLogger componentLogger = new SimpleProcessLogger(id, (Object)newNode.getProcessor(), (LoggingContext)new StandardLoggingContext((GroupedComponent)newNode));
        TerminationAwareLogger terminationAwareLogger = new TerminationAwareLogger((ComponentLog)componentLogger);
        LogRepositoryFactory.getRepository((String)id).setLogger((ComponentLog)terminationAwareLogger);
        LoggableComponent newProcessor = new LoggableComponent((ConfigurableComponent)newNode.getProcessor(), newNode.getBundleCoordinate(), terminationAwareLogger);
        existingNode.setProcessor(newProcessor);
        existingNode.setExtensionMissing(newNode.isExtensionMissing());
        existingNode.refreshProperties();
        Class componentClass = existingNode.getProcessor() == null ? null : existingNode.getProcessor().getClass();
        StandardProcessContext processContext = new StandardProcessContext(existingNode, this.statelessEngine.getControllerServiceProvider(), this.statelessEngine.getStateManagerProvider().getStateManager(id, componentClass), () -> false, (NodeTypeProvider)new StatelessNodeTypeProvider());
        existingNode.onConfigurationRestored((ProcessContext)processContext);
        logger.debug("Successfully reloaded {}", (Object)existingNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(ControllerServiceNode existingNode, String newType, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls) throws ControllerServiceInstantiationException {
        if (existingNode == null) {
            throw new IllegalStateException("Existing ControllerServiceNode cannot be null");
        }
        String id = existingNode.getIdentifier();
        if (existingNode.getLogger() != null) {
            existingNode.getLogger().debug("Reloading component {} to type {} from bundle {}", new Object[]{id, newType, bundleCoordinate});
        }
        ExtensionManager extensionManager = this.statelessEngine.getExtensionManager();
        InstanceClassLoader existingInstanceClassLoader = extensionManager.getInstanceClassLoader(id);
        ControllerServiceNode newNode = this.statelessEngine.getFlowManager().createControllerService(newType, id, bundleCoordinate, additionalUrls, true, false, null);
        try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ClassLoader)existingInstanceClassLoader);){
            StandardConfigurationContext configurationContext = new StandardConfigurationContext((ComponentNode)existingNode, (ControllerServiceLookup)this.statelessEngine.getControllerServiceProvider(), null);
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)existingNode.getControllerServiceImplementation(), (Object[])new Object[]{configurationContext});
        }
        finally {
            extensionManager.closeURLClassLoader(id, (ClassLoader)existingInstanceClassLoader);
        }
        ControllerServiceInvocationHandler invocationHandler = newNode.getInvocationHandler();
        invocationHandler.setServiceNode(existingNode);
        SimpleProcessLogger componentLogger = new SimpleProcessLogger(id, (Object)newNode.getControllerServiceImplementation(), (LoggingContext)new StandardLoggingContext((GroupedComponent)newNode));
        TerminationAwareLogger terminationAwareLogger = new TerminationAwareLogger((ComponentLog)componentLogger);
        LogRepositoryFactory.getRepository((String)id).setLogger((ComponentLog)terminationAwareLogger);
        LoggableComponent loggableProxy = new LoggableComponent((ConfigurableComponent)newNode.getProxiedControllerService(), bundleCoordinate, terminationAwareLogger);
        LoggableComponent loggableImplementation = new LoggableComponent((ConfigurableComponent)newNode.getControllerServiceImplementation(), bundleCoordinate, terminationAwareLogger);
        existingNode.setControllerServiceAndProxy(loggableImplementation, loggableProxy, invocationHandler);
        existingNode.setExtensionMissing(newNode.isExtensionMissing());
        existingNode.refreshProperties();
        logger.debug("Successfully reloaded {}", (Object)existingNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(ReportingTaskNode existingNode, String newType, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls) {
        if (existingNode == null) {
            throw new IllegalStateException("Existing ReportingTaskNode cannot be null");
        }
        String id = existingNode.getReportingTask().getIdentifier();
        if (existingNode.getLogger() != null) {
            existingNode.getLogger().debug("Reloading component {} to type {} from bundle {}", new Object[]{id, newType, bundleCoordinate});
        }
        ExtensionManager extensionManager = this.statelessEngine.getExtensionManager();
        InstanceClassLoader existingInstanceClassLoader = extensionManager.getInstanceClassLoader(id);
        ReportingTaskNode newNode = this.statelessEngine.getFlowManager().createReportingTask(newType, id, bundleCoordinate, additionalUrls, true, false, null);
        try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ClassLoader)existingInstanceClassLoader);){
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)existingNode.getReportingTask(), (Object[])new Object[]{existingNode.getConfigurationContext()});
        }
        finally {
            extensionManager.closeURLClassLoader(id, (ClassLoader)existingInstanceClassLoader);
        }
        SimpleProcessLogger componentLogger = new SimpleProcessLogger(id, (Object)existingNode.getReportingTask(), (LoggingContext)new StandardLoggingContext());
        TerminationAwareLogger terminationAwareLogger = new TerminationAwareLogger((ComponentLog)componentLogger);
        LogRepositoryFactory.getRepository((String)id).setLogger((ComponentLog)terminationAwareLogger);
        LoggableComponent newReportingTask = new LoggableComponent((ConfigurableComponent)newNode.getReportingTask(), newNode.getBundleCoordinate(), terminationAwareLogger);
        existingNode.setReportingTask(newReportingTask);
        existingNode.setExtensionMissing(newNode.isExtensionMissing());
        existingNode.refreshProperties();
        logger.debug("Successfully reloaded {}", (Object)existingNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(ParameterProviderNode existingNode, String newType, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls) {
        if (existingNode == null) {
            throw new IllegalStateException("Existing ParameterProviderNode cannot be null");
        }
        String id = existingNode.getParameterProvider().getIdentifier();
        if (existingNode.getLogger() != null) {
            existingNode.getLogger().debug("Reloading component {} to type {} from bundle {}", new Object[]{id, newType, bundleCoordinate});
        }
        ExtensionManager extensionManager = this.statelessEngine.getExtensionManager();
        InstanceClassLoader existingInstanceClassLoader = extensionManager.getInstanceClassLoader(id);
        ParameterProviderNode newNode = this.statelessEngine.getFlowManager().createParameterProvider(newType, id, bundleCoordinate, additionalUrls, true, false);
        try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ClassLoader)existingInstanceClassLoader);){
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)existingNode.getParameterProvider(), (Object[])new Object[]{existingNode.getConfigurationContext()});
        }
        finally {
            extensionManager.closeURLClassLoader(id, (ClassLoader)existingInstanceClassLoader);
        }
        SimpleProcessLogger componentLogger = new SimpleProcessLogger(id, (Object)existingNode.getParameterProvider(), (LoggingContext)new StandardLoggingContext());
        TerminationAwareLogger terminationAwareLogger = new TerminationAwareLogger((ComponentLog)componentLogger);
        LogRepositoryFactory.getRepository((String)id).setLogger((ComponentLog)terminationAwareLogger);
        LoggableComponent newParameterProvider = new LoggableComponent((ConfigurableComponent)newNode.getParameterProvider(), newNode.getBundleCoordinate(), terminationAwareLogger);
        existingNode.setParameterProvider(newParameterProvider);
        existingNode.setExtensionMissing(newNode.isExtensionMissing());
        existingNode.refreshProperties();
        logger.debug("Successfully reloaded {}", (Object)existingNode);
    }

    public void reload(FlowRegistryClientNode existingNode, String newType, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls) throws FlowRepositoryClientInstantiationException {
        if (existingNode == null) {
            throw new IllegalStateException("Existing ParameterProviderNode cannot be null");
        }
        String id = existingNode.getComponent().getIdentifier();
        if (existingNode.getLogger() != null) {
            existingNode.getLogger().debug("Reloading component {} to type {} from bundle {}", new Object[]{id, newType, bundleCoordinate});
        }
        ExtensionManager extensionManager = this.statelessEngine.getExtensionManager();
        InstanceClassLoader existingInstanceClassLoader = extensionManager.getInstanceClassLoader(id);
        FlowRegistryClientNode newNode = this.statelessEngine.getFlowManager().createFlowRegistryClient(newType, id, bundleCoordinate, additionalUrls, true, false, null);
        extensionManager.closeURLClassLoader(id, (ClassLoader)existingInstanceClassLoader);
        SimpleProcessLogger componentLogger = new SimpleProcessLogger(id, (Object)existingNode.getComponent(), (LoggingContext)new StandardLoggingContext());
        TerminationAwareLogger terminationAwareLogger = new TerminationAwareLogger((ComponentLog)componentLogger);
        LogRepositoryFactory.getRepository((String)id).setLogger((ComponentLog)terminationAwareLogger);
        LoggableComponent newClient = new LoggableComponent(newNode.getComponent(), newNode.getBundleCoordinate(), terminationAwareLogger);
        existingNode.setComponent(newClient);
        existingNode.setExtensionMissing(newNode.isExtensionMissing());
        existingNode.refreshProperties();
        logger.debug("Successfully reloaded {}", (Object)existingNode);
    }

    public void reload(FlowAnalysisRuleNode existingNode, String newType, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls) throws FlowAnalysisRuleInstantiationException {
    }
}

