/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import org.apache.nifi.flow.VersionedExternalFlow;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.registry.VersionedFlowConverter;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;
import org.apache.nifi.stateless.config.ParameterContextDefinition;
import org.apache.nifi.stateless.config.ParameterDefinition;
import org.apache.nifi.stateless.config.ParameterOverride;
import org.apache.nifi.stateless.config.ParameterValueProviderDefinition;
import org.apache.nifi.stateless.config.ReportingTaskDefinition;
import org.apache.nifi.stateless.config.SslConfigurationUtil;
import org.apache.nifi.stateless.config.SslContextDefinition;
import org.apache.nifi.stateless.config.StatelessConfigurationException;
import org.apache.nifi.stateless.core.RegistryFlowSnapshotProvider;
import org.apache.nifi.stateless.engine.StatelessEngineConfiguration;
import org.apache.nifi.stateless.flow.DataflowDefinition;
import org.apache.nifi.stateless.flow.DataflowDefinitionParser;
import org.apache.nifi.stateless.flow.StandardDataflowDefinition;
import org.apache.nifi.stateless.flow.TransactionThresholds;
import org.apache.nifi.stateless.parameter.EnvironmentVariableParameterValueProvider;
import org.apache.nifi.stateless.parameter.OverrideParameterValueProvider;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.web.client.StandardWebClientService;
import org.apache.nifi.web.client.api.HttpResponseEntity;
import org.apache.nifi.web.client.api.WebClientService;
import org.apache.nifi.web.client.redirect.RedirectHandling;
import org.apache.nifi.web.client.ssl.TlsContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFileFlowDefinitionParser
implements DataflowDefinitionParser {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesFileFlowDefinitionParser.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Pattern PROPERTY_LINE_PATTERN = Pattern.compile("(.*?)(?<!\\\\)=(.*)");
    private static final Pattern PARAMETER_CONTEXT_PATTERN = Pattern.compile("\\Qnifi.stateless.parameters.\\E(.*?)(\\..*)?");
    private static final Pattern REPORTING_TASK_PATTERN = Pattern.compile("\\Qnifi.stateless.reporting.task.\\E(.*?)\\.(.*)");
    private static final String PARAMETER_PROVIDER_PREFIX = "nifi.stateless.parameter.provider.";
    private static final Pattern PARAMETER_PROVIDER_PATTERN = Pattern.compile("\\Qnifi.stateless.parameter.provider.\\E(.*?)\\.(.*)");
    private static final Pattern ENV_VARIABLE_PATTERN = Pattern.compile("env\\{(.*)}");
    private static final String PROPERTIES_PREFIX = "properties.";
    private static final String FAILURE_PORTS_KEY = "nifi.stateless.failure.port.names";
    private static final String REGISTRY_URL_KEY = "nifi.stateless.registry.url";
    private static final String BUCKET_ID_KEY = "nifi.stateless.flow.bucketId";
    private static final String FLOW_ID_KEY = "nifi.stateless.flow.id";
    private static final String FLOW_VERSION_KEY = "nifi.stateless.flow.version";
    private static final String FLOW_SNAPSHOT_FILE_KEY = "nifi.stateless.flow.snapshot.file";
    private static final String FLOW_SNAPSHOT_URL_KEY = "nifi.stateless.flow.snapshot.url";
    private static final String FLOW_SNAPSHOT_CONTENTS_KEY = "nifi.stateless.flow.snapshot.contents";
    private static final String FLOW_SNAPSHOT_URL_USE_SSLCONTEXT_KEY = "nifi.stateless.flow.snapshot.url.use.ssl.context";
    private static final String TRANSACTION_THRESHOLD_FLOWFILES = "nifi.stateless.transaction.thresholds.flowfiles";
    private static final String TRANSACTION_THRESHOLD_DATA_SIZE = "nifi.stateless.transaction.thresholds.bytes";
    private static final String TRANSACTION_THRESHOLD_TIME = "nifi.stateless.transaction.thresholds.time";

    public DataflowDefinition parseFlowDefinition(File propertiesFile, StatelessEngineConfiguration engineConfig, List<ParameterOverride> parameterOverrides) throws IOException, StatelessConfigurationException {
        Map<String, String> properties = this.readPropertyValues(propertiesFile);
        return this.parseFlowDefinition(properties, engineConfig, parameterOverrides);
    }

    public DataflowDefinition parseFlowDefinition(Map<String, String> properties, StatelessEngineConfiguration engineConfig, List<ParameterOverride> parameterOverrides) throws IOException, StatelessConfigurationException {
        this.warnOnWhitespace(properties);
        Set<String> failurePortNames = this.getFailurePortNames(properties);
        VersionedFlowSnapshot flowSnapshot = this.fetchVersionedFlowSnapshot(properties, engineConfig.getSslContext());
        VersionedExternalFlow externalFlow = VersionedFlowConverter.createVersionedExternalFlow((VersionedFlowSnapshot)flowSnapshot);
        List<ParameterContextDefinition> parameterContextDefinitions = this.getParameterContexts(properties);
        List<ReportingTaskDefinition> reportingTaskDefinitions = this.getReportingTasks(properties);
        List<ParameterValueProviderDefinition> parameterValueProviderDefinitions = this.getParameterValueProviders(properties, parameterOverrides);
        TransactionThresholds transactionThresholds = this.getTransactionThresholds(properties);
        return new StandardDataflowDefinition.Builder().versionedExternalFlow(externalFlow).failurePortNames(failurePortNames).parameterContexts(parameterContextDefinitions).reportingTasks(reportingTaskDefinitions).parameterValueProviders(parameterValueProviderDefinitions).transactionThresholds(transactionThresholds).build();
    }

    private List<ReportingTaskDefinition> getReportingTasks(Map<String, String> properties) {
        LinkedHashMap<String, ReportingTaskDefinition> reportingTaskDefinitions = new LinkedHashMap<String, ReportingTaskDefinition>();
        block12: for (String propertyName : properties.keySet()) {
            Matcher matcher = REPORTING_TASK_PATTERN.matcher(propertyName);
            if (!matcher.matches()) continue;
            String reportingTaskKey = matcher.group(1);
            ReportingTaskDefinition definition = reportingTaskDefinitions.computeIfAbsent(reportingTaskKey, key -> new ReportingTaskDefinition());
            String relativePropertyName = matcher.group(2);
            String propertyValue = properties.get(propertyName);
            if (relativePropertyName.startsWith(PROPERTIES_PREFIX)) {
                if (relativePropertyName.length() < 12) {
                    logger.warn("Encountered unexpected property <{}> in flow definition. This property will be ignored.", (Object)propertyName);
                    continue;
                }
                String reportingTaskPropertyName = relativePropertyName.substring(11);
                definition.getPropertyValues().put(reportingTaskPropertyName, propertyValue);
                continue;
            }
            switch (relativePropertyName) {
                case "name": {
                    definition.setName(propertyValue);
                    continue block12;
                }
                case "type": {
                    definition.setType(propertyValue);
                    continue block12;
                }
                case "frequency": {
                    definition.setSchedulingFrequency(propertyValue);
                    continue block12;
                }
                case "bundle": {
                    definition.setBundleCoordinates(propertyValue);
                    continue block12;
                }
            }
            logger.warn("Encountered unexpected property <{}> in flow definition. This property will be ignored.", (Object)propertyName);
        }
        return new ArrayList<ReportingTaskDefinition>(reportingTaskDefinitions.values());
    }

    private List<ParameterValueProviderDefinition> getParameterValueProviders(Map<String, String> properties, List<ParameterOverride> parameterOverrides) {
        LinkedHashMap<String, ParameterValueProviderDefinition> parameterValueProviderDefinitions = new LinkedHashMap<String, ParameterValueProviderDefinition>();
        parameterValueProviderDefinitions.put("Default Parameter Override Provider", this.createParameterOverrideProvider(parameterOverrides));
        parameterValueProviderDefinitions.put("Default Environment Variable Provider", this.createEnvironmentVariableProvider());
        block10: for (String string : properties.keySet()) {
            Matcher matcher = PARAMETER_PROVIDER_PATTERN.matcher(string);
            if (!matcher.matches()) continue;
            String parameterValueProviderKey = matcher.group(1);
            ParameterValueProviderDefinition definition = parameterValueProviderDefinitions.computeIfAbsent(parameterValueProviderKey, key -> new ParameterValueProviderDefinition());
            definition.setName(parameterValueProviderKey);
            String relativePropertyName = matcher.group(2);
            String propertyValue = properties.get(string);
            if (relativePropertyName.startsWith(PROPERTIES_PREFIX)) {
                if (relativePropertyName.length() <= PROPERTIES_PREFIX.length()) {
                    logger.warn("Encountered unexpected property <{}> in flow definition. This property will be ignored.", (Object)string);
                    continue;
                }
                String providerPropertyName = relativePropertyName.substring(PROPERTIES_PREFIX.length());
                definition.getPropertyValues().put(providerPropertyName, propertyValue);
                continue;
            }
            switch (relativePropertyName) {
                case "name": {
                    definition.setName(propertyValue);
                    continue block10;
                }
                case "type": {
                    definition.setType(propertyValue);
                    continue block10;
                }
                case "bundle": {
                    definition.setBundleCoordinates(propertyValue);
                    continue block10;
                }
            }
            logger.warn("Encountered unexpected property <{}> in flow definition. This property will be ignored.", (Object)string);
        }
        for (Map.Entry entry : parameterValueProviderDefinitions.entrySet()) {
            String providerKey = (String)entry.getKey();
            ParameterValueProviderDefinition definition = (ParameterValueProviderDefinition)entry.getValue();
            if (definition.getName() == null) {
                logger.warn("Parameter Value Provider identified in Properties with key <{}> was not provided a name. Will default name to <{}>", (Object)providerKey, (Object)providerKey);
                definition.setName(providerKey);
            }
            if (definition.getType() != null) continue;
            throw new IllegalArgumentException("Parameter Value Provider <" + definition.getName() + "> does not have a Type set. This must be set by adding a property named nifi.stateless.parameter.provider." + providerKey + ".type");
        }
        return new ArrayList<ParameterValueProviderDefinition>(parameterValueProviderDefinitions.values());
    }

    private ParameterValueProviderDefinition createEnvironmentVariableProvider() {
        ParameterValueProviderDefinition overrideProvider = new ParameterValueProviderDefinition();
        overrideProvider.setType(EnvironmentVariableParameterValueProvider.class.getName());
        overrideProvider.setName("Environment Variable Parameter Value Provider");
        overrideProvider.setPropertyValues(Collections.emptyMap());
        return overrideProvider;
    }

    private ParameterValueProviderDefinition createParameterOverrideProvider(List<ParameterOverride> parameterOverrides) {
        ParameterValueProviderDefinition overrideProvider = new ParameterValueProviderDefinition();
        overrideProvider.setType(OverrideParameterValueProvider.class.getName());
        overrideProvider.setName("Parameter Override Provider");
        LinkedHashMap<String, String> propertyValues = new LinkedHashMap<String, String>();
        for (ParameterOverride override : parameterOverrides) {
            String contextName = override.getContextName();
            String parameterName = override.getParameterName();
            String propertyName = contextName == null ? parameterName : contextName + ":" + parameterName;
            propertyValues.put(propertyName, override.getParameterValue());
        }
        overrideProvider.setPropertyValues(propertyValues);
        return overrideProvider;
    }

    private List<ParameterContextDefinition> getParameterContexts(Map<String, String> properties) {
        LinkedHashMap<String, ParameterContextDefinition> contextDefinitions = new LinkedHashMap<String, ParameterContextDefinition>();
        for (String propertyName : properties.keySet()) {
            Matcher matcher = PARAMETER_CONTEXT_PATTERN.matcher(propertyName);
            if (!matcher.matches()) continue;
            String parameterContextKey = matcher.group(1);
            ParameterContextDefinition paramContext = contextDefinitions.computeIfAbsent(parameterContextKey, key -> new ParameterContextDefinition());
            String parameterName = matcher.group(2);
            String value = properties.get(propertyName);
            if (parameterName == null) {
                paramContext.setName(value);
                continue;
            }
            if (paramContext.getName() == null) {
                paramContext.setName(parameterContextKey);
            }
            if (parameterName.equals(".")) continue;
            parameterName = parameterName.substring(1);
            ArrayList<ParameterDefinition> parameterDefinitions = paramContext.getParameters();
            if (parameterDefinitions == null) {
                parameterDefinitions = new ArrayList<ParameterDefinition>();
            }
            ParameterDefinition parameter = new ParameterDefinition();
            parameter.setName(parameterName);
            parameter.setValue(value);
            parameterDefinitions.add(parameter);
            paramContext.setParameters(parameterDefinitions);
        }
        return new ArrayList<ParameterContextDefinition>(contextDefinitions.values());
    }

    private TransactionThresholds getTransactionThresholds(Map<String, String> properties) {
        Long flowfileThreshold = this.getLongProperty(properties, TRANSACTION_THRESHOLD_FLOWFILES);
        Double dataSizeThreshold = this.getDataSizeProperty(properties, TRANSACTION_THRESHOLD_DATA_SIZE);
        Double timeThreshold = this.getTimePeriodProperty(properties, TRANSACTION_THRESHOLD_TIME);
        final OptionalLong maxFlowFiles = flowfileThreshold == null ? OptionalLong.empty() : OptionalLong.of(flowfileThreshold);
        final OptionalLong maxBytes = dataSizeThreshold == null ? OptionalLong.empty() : OptionalLong.of(dataSizeThreshold.longValue());
        final OptionalLong maxNanos = timeThreshold == null ? OptionalLong.empty() : OptionalLong.of(timeThreshold.longValue());
        return new TransactionThresholds(){

            public OptionalLong getMaxFlowFiles() {
                return maxFlowFiles;
            }

            public OptionalLong getMaxContentSize(DataUnit dataUnit) {
                return maxBytes.isPresent() ? OptionalLong.of((long)dataUnit.convert((double)maxBytes.getAsLong(), DataUnit.B)) : OptionalLong.empty();
            }

            public OptionalLong getMaxTime(TimeUnit timeUnit) {
                return maxNanos.isPresent() ? OptionalLong.of(timeUnit.convert(maxNanos.getAsLong(), TimeUnit.NANOSECONDS)) : OptionalLong.empty();
            }
        };
    }

    private String getTrimmedProperty(Map<String, String> properties, String propertyName) {
        String propertyValue = properties.get(propertyName);
        return propertyValue == null || propertyValue.isBlank() ? null : propertyValue.trim();
    }

    private Long getLongProperty(Map<String, String> properties, String propertyName) {
        String propertyValue = this.getTrimmedProperty(properties, propertyName);
        try {
            return propertyValue == null ? null : Long.valueOf(Long.parseLong(propertyValue));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Configured property <" + propertyName + "> has a value that is not a valid 64-bit integer");
        }
    }

    private Double getDataSizeProperty(Map<String, String> properties, String propertyName) {
        String propertyValue = this.getTrimmedProperty(properties, propertyName);
        try {
            return propertyValue == null ? null : DataUnit.parseDataSize((String)propertyValue, (DataUnit)DataUnit.B);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Configured property <" + propertyName + "> has a value that is not a valid data size");
        }
    }

    private Double getTimePeriodProperty(Map<String, String> properties, String propertyName) {
        String propertyValue = this.getTrimmedProperty(properties, propertyName);
        try {
            return propertyValue == null ? null : Double.valueOf(FormatUtils.getPreciseTimeDuration((String)propertyValue, (TimeUnit)TimeUnit.NANOSECONDS));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Configured property <" + propertyName + "> has a value that is not a valid time period");
        }
    }

    private Set<String> getFailurePortNames(Map<String, String> properties) {
        HashSet<String> failurePortNames = new HashSet<String>();
        for (String portName : properties.getOrDefault(FAILURE_PORTS_KEY, "").split(",")) {
            failurePortNames.add(portName.trim());
        }
        return failurePortNames;
    }

    private void warnOnWhitespace(Map<String, String> properties) {
        properties.forEach((key, value) -> {
            if (value == null) {
                return;
            }
            if (!key.trim().equals(key)) {
                logger.warn("Found property with name <{}>. This property name contains leading or trailing white space, which may not be intended.", key);
            }
            if (!value.trim().equals(value) && !value.isBlank()) {
                logger.warn("Found property with name <{}> and value <{}>. This property value contains leading or trailing white space, which may not be intended.", key, value);
            }
        });
    }

    private Map<String, String> readPropertyValues(File propertiesFile) throws IOException {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        try (FileInputStream in = new FileInputStream(propertiesFile);
             InputStreamReader inReader = new InputStreamReader(in);
             BufferedReader reader = new BufferedReader(inReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                String trimmed = line.trim();
                if (trimmed.startsWith("#") || trimmed.startsWith("!") || trimmed.isEmpty()) continue;
                Matcher matcher = PROPERTY_LINE_PATTERN.matcher(line);
                if (!matcher.matches()) {
                    logger.warn("Encountered line in properties file {} that is not a comment, not blank, and does not adhere to the format of <propertyName>=<propertyValue>: {}", (Object)propertiesFile.getAbsolutePath(), (Object)line);
                    continue;
                }
                String propertyName = matcher.group(1);
                String propertyValue = this.substituteEnvironmentVariables(matcher.group(2));
                properties.put(propertyName, propertyValue);
            }
        }
        return properties;
    }

    private String substituteEnvironmentVariables(String propertyValue) {
        Matcher matcher = ENV_VARIABLE_PATTERN.matcher(propertyValue);
        if (!matcher.matches()) {
            return propertyValue;
        }
        String envVariable = matcher.group(1);
        String envValue = System.getenv(envVariable);
        return envValue == null ? "" : envValue;
    }

    private VersionedFlowSnapshot fetchVersionedFlowSnapshot(Map<String, String> properties, SslContextDefinition sslContextDefinition) throws IOException, StatelessConfigurationException {
        Integer flowVersion;
        String flowSnapshotFilename = properties.get(FLOW_SNAPSHOT_FILE_KEY);
        if (flowSnapshotFilename != null && !flowSnapshotFilename.isBlank()) {
            File flowSnapshotFile = new File(flowSnapshotFilename.trim());
            try {
                return this.readVersionedFlowSnapshot(flowSnapshotFile);
            }
            catch (Exception e) {
                throw new IOException("Configuration indicates that the flow to run is located at " + flowSnapshotFilename + " but failed to load dataflow from that location", e);
            }
        }
        String flowSnapshotUrl = properties.get(FLOW_SNAPSHOT_URL_KEY);
        if (flowSnapshotUrl != null && !flowSnapshotUrl.isBlank()) {
            String useSslPropertyValue = properties.get(FLOW_SNAPSHOT_URL_USE_SSLCONTEXT_KEY);
            boolean useSsl = Boolean.parseBoolean(useSslPropertyValue);
            try {
                return this.fetchFlowFromUrl(flowSnapshotUrl, (SslContextDefinition)(useSsl ? sslContextDefinition : null));
            }
            catch (Exception e) {
                throw new StatelessConfigurationException("Could not fetch flow from URL", (Throwable)e);
            }
        }
        String flowContents = properties.get(FLOW_SNAPSHOT_CONTENTS_KEY);
        if (flowContents != null && !flowContents.isBlank()) {
            VersionedFlowSnapshot versionedFlowSnapshot;
            byte[] flowContentsBytes = flowContents.getBytes(StandardCharsets.UTF_8);
            ByteArrayInputStream in = new ByteArrayInputStream(flowContentsBytes);
            try {
                versionedFlowSnapshot = this.readVersionedFlowSnapshot(in);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException("Configuration includes escaped JSON contents but failed to parse the dataflow", e);
                }
            }
            ((InputStream)in).close();
            return versionedFlowSnapshot;
        }
        String registryUrl = properties.get(REGISTRY_URL_KEY);
        String bucketId = properties.get(BUCKET_ID_KEY);
        String flowId = properties.get(FLOW_ID_KEY);
        String flowVersionValue = properties.get(FLOW_VERSION_KEY);
        try {
            flowVersion = this.isEmpty(flowVersionValue) ? null : Integer.valueOf(Integer.parseInt(flowVersionValue));
        }
        catch (NumberFormatException nfe) {
            throw new StatelessConfigurationException("The nifi.stateless.flow.version property was expected to contain a number but had a value of " + flowVersionValue);
        }
        if (this.isEmpty(registryUrl) || this.isEmpty(bucketId) || this.isEmpty(flowId)) {
            throw new IllegalArgumentException("Configuration does not provide the filename of the flow to run; a URL to fetch it from; the dataflow contents; or the registryUrl, bucketId, and flowId.");
        }
        try {
            SSLContext sslContext = SslConfigurationUtil.createSslContext(sslContextDefinition);
            return this.fetchFlowFromRegistry(registryUrl, bucketId, flowId, flowVersion, sslContext);
        }
        catch (IOException e) {
            throw new StatelessConfigurationException("Could not fetch flow from Registry", (Throwable)e);
        }
    }

    private boolean isEmpty(String value) {
        return value == null || value.isBlank();
    }

    private VersionedFlowSnapshot fetchFlowFromUrl(String url, SslContextDefinition sslContextDefinition) throws IOException {
        WebClientService webClientService = this.getWebClientService(sslContextDefinition);
        URI uri = URI.create(url);
        HttpResponseEntity responseEntity = webClientService.get().uri(uri).retrieve();
        InputStream responseBody = responseEntity.body();
        int statusCode = responseEntity.statusCode();
        if (statusCode == 200) {
            try {
                VersionedFlowSnapshot versionedFlowSnapshot = (VersionedFlowSnapshot)OBJECT_MAPPER.readValue(responseBody, VersionedFlowSnapshot.class);
                return versionedFlowSnapshot;
            }
            catch (Exception e) {
                throw new IOException("Downloaded flow from " + url + " but failed to parse the contents as a Versioned Flow. Please verify that the correct URL was provided.", e);
            }
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        InputStream body = responseEntity.body();
        body.transferTo(outputStream);
        String responseMessage = outputStream.toString();
        String message = "Failed to download flow from URL %s HTTP %d %s".formatted(url, statusCode, responseMessage);
        throw new IOException(message);
        {
            finally {
                if (responseBody != null) {
                    responseBody.close();
                }
            }
        }
        finally {
            if (responseEntity != null) {
                responseEntity.close();
            }
        }
    }

    private WebClientService getWebClientService(SslContextDefinition sslContextDefinition) throws IOException {
        StandardWebClientService webClientService = new StandardWebClientService();
        Duration timeout = Duration.ofSeconds(30L);
        webClientService.setConnectTimeout(timeout);
        webClientService.setReadTimeout(timeout);
        webClientService.setRedirectHandling(RedirectHandling.FOLLOWED);
        if (sslContextDefinition != null) {
            try {
                TlsContext tlsContext = SslConfigurationUtil.createTlsContext(sslContextDefinition);
                webClientService.setTlsContext(tlsContext);
            }
            catch (StatelessConfigurationException e) {
                throw new IOException("Web Client Service TLS Configuration failed", e);
            }
        }
        return webClientService;
    }

    private VersionedFlowSnapshot fetchFlowFromRegistry(String registryUrl, String bucketId, String flowId, Integer flowVersion, SSLContext sslContext) throws IOException {
        logger.info("Fetching flow from NiFi Registry at {}", (Object)registryUrl);
        long start = System.currentTimeMillis();
        RegistryFlowSnapshotProvider flowSnapshotProvider = new RegistryFlowSnapshotProvider(registryUrl, sslContext);
        VersionedFlowSnapshot snapshot = flowSnapshotProvider.getFlowSnapshot(bucketId, flowId, flowVersion == null ? -1 : flowVersion);
        long millis = System.currentTimeMillis() - start;
        logger.info("Successfully fetched flow from NiFi Registry in {} millis", (Object)millis);
        return snapshot;
    }

    private VersionedFlowSnapshot readVersionedFlowSnapshot(File snapshotFile) throws IOException {
        try (FileInputStream fis = new FileInputStream(snapshotFile);){
            VersionedFlowSnapshot versionedFlowSnapshot = this.readVersionedFlowSnapshot(fis);
            return versionedFlowSnapshot;
        }
    }

    private VersionedFlowSnapshot readVersionedFlowSnapshot(InputStream in) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        VersionedFlowSnapshot snapshot = (VersionedFlowSnapshot)objectMapper.readValue(in, VersionedFlowSnapshot.class);
        VersionedFlowSnapshotMetadata metadata = new VersionedFlowSnapshotMetadata();
        metadata.setBucketIdentifier("external-bucket");
        metadata.setFlowIdentifier("external-flow");
        metadata.setTimestamp(System.currentTimeMillis());
        metadata.setVersion(1);
        snapshot.setSnapshotMetadata(metadata);
        return snapshot;
    }
}

