/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.reporting;

import java.util.Map;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.reporting.AbstractReportingContext;
import org.apache.nifi.controller.reporting.StatelessEventAccess;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.reporting.EventAccess;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.stateless.engine.StatelessEngine;

public class StatelessReportingContext
extends AbstractReportingContext
implements ReportingContext {
    private final StatelessEngine statelessEngine;
    private final FlowManager flowManager;

    public StatelessReportingContext(StatelessEngine statelessEngine, FlowManager flowManager, Map<PropertyDescriptor, String> properties, ReportingTaskNode reportingTaskNode, ParameterLookup parameterLookup) {
        super(reportingTaskNode, statelessEngine.getBulletinRepository(), properties, statelessEngine.getControllerServiceProvider(), parameterLookup);
        this.statelessEngine = statelessEngine;
        this.flowManager = flowManager;
    }

    public EventAccess getEventAccess() {
        return new StatelessEventAccess(this.statelessEngine.getProcessScheduler(), null, this.flowManager, this.statelessEngine.getFlowFileEventRepository(), this.statelessEngine.getProvenanceRepository());
    }

    public FlowManager getFlowManager() {
        return this.flowManager;
    }

    public StateManager getStateManager() {
        Class componentClass = this.getReportingTask() == null ? null : this.getReportingTask().getClass();
        return this.statelessEngine.getStateManagerProvider().getStateManager(this.getReportingTask().getIdentifier(), componentClass);
    }

    public boolean isClustered() {
        return false;
    }

    public String getClusterNodeIdentifier() {
        return null;
    }
}

