/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.repository;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.CounterRepository;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.RepositoryContext;
import org.apache.nifi.provenance.ProvenanceEventRepository;
import org.apache.nifi.stateless.repository.RepositoryContextFactory;
import org.apache.nifi.stateless.repository.StatelessRepositoryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatelessRepositoryContextFactory
implements RepositoryContextFactory {
    private static final Logger logger = LoggerFactory.getLogger(StatelessRepositoryContextFactory.class);
    private final ContentRepository contentRepository;
    private final FlowFileRepository flowFileRepository;
    private final FlowFileEventRepository flowFileEventRepository;
    private final CounterRepository counterRepository;
    private final StateManagerProvider stateManagerProvider;

    public StatelessRepositoryContextFactory(ContentRepository contentRepository, FlowFileRepository flowFileRepository, FlowFileEventRepository flowFileEventRepository, CounterRepository counterRepository, ProvenanceEventRepository provenanceRepository, StateManagerProvider stateManagerProvider) {
        this.contentRepository = contentRepository;
        this.flowFileRepository = flowFileRepository;
        this.flowFileEventRepository = flowFileEventRepository;
        this.counterRepository = counterRepository;
        this.stateManagerProvider = stateManagerProvider;
    }

    @Override
    public RepositoryContext createRepositoryContext(Connectable connectable, ProvenanceEventRepository provenanceEventRepository) {
        StateManager stateManager = this.stateManagerProvider.getStateManager(connectable.getIdentifier());
        return new StatelessRepositoryContext(connectable, new AtomicLong(0L), this.contentRepository, this.flowFileRepository, this.flowFileEventRepository, this.counterRepository, provenanceEventRepository, stateManager);
    }

    @Override
    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    @Override
    public FlowFileRepository getFlowFileRepository() {
        return this.flowFileRepository;
    }

    @Override
    public FlowFileEventRepository getFlowFileEventRepository() {
        return this.flowFileEventRepository;
    }

    @Override
    public void shutdown() {
        this.contentRepository.shutdown();
        try {
            this.flowFileRepository.close();
        }
        catch (IOException e) {
            logger.warn("Failed to properly shutdown FlowFile Repository", (Throwable)e);
        }
        try {
            this.flowFileEventRepository.close();
        }
        catch (IOException e) {
            logger.warn("Failed to properly shutdown FlowFile Event Repository", (Throwable)e);
        }
    }
}

