/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.util;

import java.util.Map;
import org.apache.nifi.ssl.StandardSSLContextService;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class TestServer {
    public static final String NEED_CLIENT_AUTH = "clientAuth";
    private Server jetty;
    private boolean secure = false;

    public TestServer() {
        this.createServer(null);
    }

    public TestServer(Map<String, String> sslProperties) {
        this.createServer(sslProperties);
    }

    private void createServer(Map<String, String> sslProperties) {
        this.jetty = new Server();
        this.createConnector();
        if (sslProperties != null) {
            this.createSecureConnector(sslProperties);
        }
        this.jetty.setHandler((Handler)new HandlerCollection(true, new Handler[0]));
    }

    private void createConnector() {
        ServerConnector http = new ServerConnector(this.jetty);
        http.setPort(0);
        http.setIdleTimeout(30000L);
        this.jetty.addConnector((Connector)http);
    }

    private void createSecureConnector(Map<String, String> sslProperties) {
        String clientAuth;
        SslContextFactory ssl = new SslContextFactory();
        if (sslProperties.get(StandardSSLContextService.KEYSTORE.getName()) != null) {
            ssl.setKeyStorePath(sslProperties.get(StandardSSLContextService.KEYSTORE.getName()));
            ssl.setKeyStorePassword(sslProperties.get(StandardSSLContextService.KEYSTORE_PASSWORD.getName()));
            ssl.setKeyStoreType(sslProperties.get(StandardSSLContextService.KEYSTORE_TYPE.getName()));
        }
        if (sslProperties.get(StandardSSLContextService.TRUSTSTORE.getName()) != null) {
            ssl.setTrustStorePath(sslProperties.get(StandardSSLContextService.TRUSTSTORE.getName()));
            ssl.setTrustStorePassword(sslProperties.get(StandardSSLContextService.TRUSTSTORE_PASSWORD.getName()));
            ssl.setTrustStoreType(sslProperties.get(StandardSSLContextService.TRUSTSTORE_TYPE.getName()));
        }
        if ((clientAuth = sslProperties.get(NEED_CLIENT_AUTH)) == null) {
            ssl.setNeedClientAuth(true);
        } else {
            ssl.setNeedClientAuth(Boolean.parseBoolean(clientAuth));
        }
        ssl.setEndpointIdentificationAlgorithm(null);
        ServerConnector https = new ServerConnector(this.jetty, ssl);
        https.setPort(0);
        https.setIdleTimeout(30000L);
        this.jetty.addConnector((Connector)https);
        this.secure = true;
    }

    public void clearHandlers() {
        HandlerCollection hc = (HandlerCollection)this.jetty.getHandler();
        Handler[] ha = hc.getHandlers();
        if (ha != null) {
            for (Handler h : ha) {
                hc.removeHandler(h);
            }
        }
    }

    public void addHandler(Handler handler) {
        ((HandlerCollection)this.jetty.getHandler()).addHandler(handler);
    }

    public void startServer() throws Exception {
        this.jetty.start();
    }

    public void shutdownServer() throws Exception {
        this.jetty.stop();
        this.jetty.destroy();
    }

    public int getPort() {
        if (!this.jetty.isStarted()) {
            throw new IllegalStateException("Jetty server not started");
        }
        return ((ServerConnector)this.jetty.getConnectors()[0]).getLocalPort();
    }

    public int getSecurePort() {
        if (!this.jetty.isStarted()) {
            throw new IllegalStateException("Jetty server not started");
        }
        return ((ServerConnector)this.jetty.getConnectors()[1]).getLocalPort();
    }

    public String getUrl() {
        return "http://localhost:" + this.getPort();
    }

    public String getSecureUrl() {
        String url = null;
        if (this.secure) {
            url = "https://localhost:" + this.getSecurePort();
        }
        return url;
    }
}

