/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flowanalysis.rules;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedExtensionComponent;
import org.apache.nifi.flowanalysis.AbstractFlowAnalysisRule;
import org.apache.nifi.flowanalysis.ComponentAnalysisResult;
import org.apache.nifi.flowanalysis.FlowAnalysisRuleContext;
import org.apache.nifi.processor.util.StandardValidators;

@Tags(value={"component", "processor", "controller service", "type"})
@CapabilityDescription(value="Produces rule violations for each component (i.e. processors or controller services) of a given type.")
public class DisallowComponentType
extends AbstractFlowAnalysisRule {
    public static final PropertyDescriptor COMPONENT_TYPE = new PropertyDescriptor.Builder().name("component-type").displayName("Component Type").description("Components of the given type will produce a rule violation (i.e. they shouldn't exist). Either the simple or the fully qualified name of the type should be provided.").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(COMPONENT_TYPE);

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Collection<ComponentAnalysisResult> analyzeComponent(VersionedComponent component, FlowAnalysisRuleContext context) {
        HashSet<ComponentAnalysisResult> results = new HashSet<ComponentAnalysisResult>();
        String componentType = context.getProperty(COMPONENT_TYPE).getValue();
        if (component instanceof VersionedExtensionComponent) {
            VersionedExtensionComponent versionedExtensionComponent = (VersionedExtensionComponent)component;
            String encounteredComponentType = versionedExtensionComponent.getType();
            String encounteredSimpleComponentType = encounteredComponentType.substring(encounteredComponentType.lastIndexOf(".") + 1);
            if (encounteredComponentType.equals(componentType) || encounteredSimpleComponentType.equals(componentType)) {
                ComponentAnalysisResult result = new ComponentAnalysisResult("default", "'" + componentType + "' is not allowed");
                results.add(result);
            }
        }
        return results;
    }
}

