/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flowanalysis.rules;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.documentation.UseCase;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedConfigurableExtension;
import org.apache.nifi.flowanalysis.AbstractFlowAnalysisRule;
import org.apache.nifi.flowanalysis.ComponentAnalysisResult;
import org.apache.nifi.flowanalysis.FlowAnalysisRuleContext;
import org.apache.nifi.util.StringUtils;

@Tags(value={"component", "processor", "controller service", "type", "ssl", "tls", "listen"})
@CapabilityDescription(value="Produces rule violations for each component (i.e. processors or controller services) having a property identifying an SSLContextService that is not set.")
@UseCase(description="Ensure that an SSL Context has been configured for the specified components. This helps avoid ports being opened for insecure (plaintext, e.g.) communications.", configuration="To avoid the violation, ensure that the \"SSL Context Service\" property is set for the specified component(s).\n")
public class RequireServerSSLContextService
extends AbstractFlowAnalysisRule {
    private static final List<String> COMPONENT_TYPES = List.of("org.apache.nifi.processors.standard.ListenFTP", "org.apache.nifi.processors.standard.ListenHTTP", "org.apache.nifi.processors.standard.ListenTCP", "org.apache.nifi.processors.standard.ListenSyslog", "org.apache.nifi.processors.standard.HandleHttpRequest", "org.apache.nifi.websocket.jetty.JettyWebSocketServer");
    private static final String SERVICE_PROPERTY_NAME = "SSL Context Service";

    public Collection<ComponentAnalysisResult> analyzeComponent(VersionedComponent component, FlowAnalysisRuleContext context) {
        VersionedConfigurableExtension versionedConfigurableExtension;
        String encounteredComponentType;
        HashSet<ComponentAnalysisResult> results = new HashSet<ComponentAnalysisResult>();
        if (component instanceof VersionedConfigurableExtension && COMPONENT_TYPES.contains(encounteredComponentType = (versionedConfigurableExtension = (VersionedConfigurableExtension)component).getType())) {
            versionedConfigurableExtension.getProperties().forEach((propertyName, propertyValue) -> {
                if (SERVICE_PROPERTY_NAME.equals(propertyName) && StringUtils.isEmpty((String)propertyValue)) {
                    String encounteredSimpleComponentType = encounteredComponentType.substring(encounteredComponentType.lastIndexOf(".") + 1);
                    ComponentAnalysisResult result = new ComponentAnalysisResult(component.getInstanceIdentifier(), "'" + encounteredSimpleComponentType + "' must specify an SSL Context Service");
                    results.add(result);
                }
            });
        }
        return results;
    }
}

