/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.ftp.filesystem;

import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.User;
import org.apache.nifi.processors.standard.ftp.filesystem.VirtualFileSystem;
import org.apache.nifi.processors.standard.ftp.filesystem.VirtualFtpFile;
import org.apache.nifi.processors.standard.ftp.filesystem.VirtualPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualFileSystemView
implements FileSystemView {
    private static final Logger LOG = LoggerFactory.getLogger(VirtualFileSystemView.class);
    private final VirtualFileSystem fileSystem;
    private VirtualPath currentDirectory = VirtualFileSystem.ROOT;

    public VirtualFileSystemView(User user, VirtualFileSystem fileSystem) throws IllegalArgumentException {
        if (user == null || fileSystem == null) {
            throw new IllegalArgumentException("User and filesystem cannot be null.");
        }
        LOG.info("Virtual filesystem view created for user \"{}\"", (Object)user.getName());
        this.fileSystem = fileSystem;
    }

    public FtpFile getHomeDirectory() {
        return new VirtualFtpFile(VirtualFileSystem.ROOT, this.fileSystem);
    }

    public FtpFile getWorkingDirectory() {
        return new VirtualFtpFile(this.currentDirectory, this.fileSystem);
    }

    public boolean changeWorkingDirectory(String targetPath) {
        VirtualPath targetDirectory = this.currentDirectory.resolve(targetPath);
        if (this.fileSystem.exists(targetDirectory)) {
            this.currentDirectory = targetDirectory;
            return true;
        }
        return false;
    }

    public FtpFile getFile(String fileName) throws FtpException {
        VirtualPath filePath = this.currentDirectory.resolve(fileName);
        VirtualPath parent = filePath.getParent();
        if (parent != null && !this.fileSystem.exists(filePath.getParent())) {
            throw new FtpException(String.format("Parent directory does not exist for %s", filePath.toString()));
        }
        return new VirtualFtpFile(filePath, this.fileSystem);
    }

    public boolean isRandomAccessible() {
        return false;
    }

    public void dispose() {
    }
}

