/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.faker;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.datafaker.Faker;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.RecordDataType;

public enum PredefinedRecordSchema implements DescribedValue
{
    PERSON("Person", "A person with name, contact information, and address (schema.org/Person)"){

        @Override
        public RecordSchema getSchema(boolean nullable) {
            List<RecordField> addressFields = Arrays.asList(new RecordField("streetAddress", RecordFieldType.STRING.getDataType(), nullable), new RecordField("addressLocality", RecordFieldType.STRING.getDataType(), nullable), new RecordField("addressRegion", RecordFieldType.STRING.getDataType(), nullable), new RecordField("postalCode", RecordFieldType.STRING.getDataType(), nullable), new RecordField("addressCountry", RecordFieldType.STRING.getDataType(), nullable));
            SimpleRecordSchema addressSchema = new SimpleRecordSchema(addressFields);
            List<RecordField> fields = Arrays.asList(new RecordField("identifier", RecordFieldType.UUID.getDataType(), nullable), new RecordField("givenName", RecordFieldType.STRING.getDataType(), nullable), new RecordField("familyName", RecordFieldType.STRING.getDataType(), nullable), new RecordField("email", RecordFieldType.STRING.getDataType(), nullable), new RecordField("telephone", RecordFieldType.STRING.getDataType(), nullable), new RecordField("birthDate", RecordFieldType.DATE.getDataType(), nullable), new RecordField("age", RecordFieldType.INT.getDataType(), nullable), new RecordField("active", RecordFieldType.BOOLEAN.getDataType(), nullable), new RecordField("address", RecordFieldType.RECORD.getRecordDataType((RecordSchema)addressSchema), nullable));
            return new SimpleRecordSchema(fields);
        }

        @Override
        public Map<String, Object> generateValues(Faker faker, RecordSchema schema, int nullPercentage) {
            RecordSchema addressSchema;
            LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            values.put("identifier", 1.generateNullableValue(nullPercentage, faker, f -> UUID.randomUUID()));
            values.put("givenName", 1.generateNullableValue(nullPercentage, faker, f -> f.name().firstName()));
            values.put("familyName", 1.generateNullableValue(nullPercentage, faker, f -> f.name().lastName()));
            values.put("email", 1.generateNullableValue(nullPercentage, faker, f -> f.internet().emailAddress()));
            values.put("telephone", 1.generateNullableValue(nullPercentage, faker, f -> f.phoneNumber().phoneNumber()));
            values.put("birthDate", 1.generateNullableValue(nullPercentage, faker, f -> {
                LocalDate birthday = f.timeAndDate().birthday(18, 80);
                return Date.valueOf(birthday);
            }));
            values.put("age", 1.generateNullableValue(nullPercentage, faker, f -> f.number().numberBetween(18, 80)));
            values.put("active", 1.generateNullableValue(nullPercentage, faker, f -> f.bool().bool()));
            LinkedHashMap<String, String> addressValues = new LinkedHashMap<String, String>();
            addressValues.put("streetAddress", 1.generateNullableValue(nullPercentage, faker, f -> f.address().streetAddress()));
            addressValues.put("addressLocality", 1.generateNullableValue(nullPercentage, faker, f -> f.address().city()));
            addressValues.put("addressRegion", 1.generateNullableValue(nullPercentage, faker, f -> f.address().state()));
            addressValues.put("postalCode", 1.generateNullableValue(nullPercentage, faker, f -> f.address().zipCode()));
            addressValues.put("addressCountry", 1.generateNullableValue(nullPercentage, faker, f -> f.address().country()));
            RecordSchema recordSchema = addressSchema = ((RecordField)schema.getField("address").get()).getDataType().getFieldType() == RecordFieldType.RECORD ? ((RecordDataType)((RecordField)schema.getField("address").get()).getDataType()).getChildSchema() : null;
            if (addressSchema != null) {
                values.put("address", 1.generateNullableValue(nullPercentage, faker, f -> new MapRecord(addressSchema, addressValues)));
            }
            return values;
        }
    }
    ,
    ORDER("Order", "An e-commerce order with line items, amounts, and timestamps (schema.org/Order)"){

        @Override
        public RecordSchema getSchema(boolean nullable) {
            List<RecordField> orderedItemFields = Arrays.asList(new RecordField("identifier", RecordFieldType.STRING.getDataType(), nullable), new RecordField("name", RecordFieldType.STRING.getDataType(), nullable), new RecordField("orderQuantity", RecordFieldType.INT.getDataType(), nullable), new RecordField("price", RecordFieldType.DOUBLE.getDataType(), nullable));
            SimpleRecordSchema orderedItemSchema = new SimpleRecordSchema(orderedItemFields);
            List<RecordField> fields = Arrays.asList(new RecordField("orderNumber", RecordFieldType.UUID.getDataType(), nullable), new RecordField("customer", RecordFieldType.UUID.getDataType(), nullable), new RecordField("customerName", RecordFieldType.STRING.getDataType(), nullable), new RecordField("customerEmail", RecordFieldType.STRING.getDataType(), nullable), new RecordField("orderDate", RecordFieldType.DATE.getDataType(), nullable), new RecordField("orderTime", RecordFieldType.TIME.getDataType(), nullable), new RecordField("orderDelivery", RecordFieldType.TIMESTAMP.getDataType(), nullable), new RecordField("totalPrice", RecordFieldType.DECIMAL.getDecimalDataType(10, 2), nullable), new RecordField("priceCurrency", RecordFieldType.STRING.getDataType(), nullable), new RecordField("orderStatus", RecordFieldType.STRING.getDataType(), nullable), new RecordField("isGift", RecordFieldType.BOOLEAN.getDataType(), nullable), new RecordField("itemCount", RecordFieldType.INT.getDataType(), nullable), new RecordField("orderedItem", RecordFieldType.ARRAY.getArrayDataType(RecordFieldType.RECORD.getRecordDataType((RecordSchema)orderedItemSchema)), nullable));
            return new SimpleRecordSchema(fields);
        }

        @Override
        public Map<String, Object> generateValues(Faker faker, RecordSchema schema, int nullPercentage) {
            DataType elementType;
            LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            values.put("orderNumber", 2.generateNullableValue(nullPercentage, faker, f -> UUID.randomUUID()));
            values.put("customer", 2.generateNullableValue(nullPercentage, faker, f -> UUID.randomUUID()));
            values.put("customerName", 2.generateNullableValue(nullPercentage, faker, f -> f.name().fullName()));
            values.put("customerEmail", 2.generateNullableValue(nullPercentage, faker, f -> f.internet().emailAddress()));
            Instant orderInstant = faker.timeAndDate().past(365L, TimeUnit.DAYS);
            values.put("orderDate", 2.generateNullableValue(nullPercentage, faker, f -> new Date(orderInstant.toEpochMilli())));
            values.put("orderTime", 2.generateNullableValue(nullPercentage, faker, f -> new Time(orderInstant.toEpochMilli())));
            values.put("orderDelivery", 2.generateNullableValue(nullPercentage, faker, f -> new Timestamp(orderInstant.toEpochMilli())));
            String[] statuses = new String[]{"OrderCancelled", "OrderDelivered", "OrderInTransit", "OrderPaymentDue", "OrderPickupAvailable", "OrderProblem", "OrderProcessing", "OrderReturned"};
            String status = statuses[faker.number().numberBetween(0, statuses.length)];
            values.put("orderStatus", 2.generateNullableValue(nullPercentage, faker, f -> status));
            values.put("isGift", 2.generateNullableValue(nullPercentage, faker, f -> f.bool().bool()));
            values.put("priceCurrency", 2.generateNullableValue(nullPercentage, faker, f -> f.money().currencyCode()));
            int itemCount = faker.number().numberBetween(1, 5);
            values.put("itemCount", 2.generateNullableValue(nullPercentage, faker, f -> itemCount));
            RecordSchema orderedItemSchema = null;
            if (((RecordField)schema.getField("orderedItem").get()).getDataType().getFieldType() == RecordFieldType.ARRAY && (elementType = ((ArrayDataType)((RecordField)schema.getField("orderedItem").get()).getDataType()).getElementType()).getFieldType() == RecordFieldType.RECORD) {
                orderedItemSchema = ((RecordDataType)elementType).getChildSchema();
            }
            double totalPrice = 0.0;
            Object[] orderedItems = new Object[itemCount];
            for (int i = 0; i < itemCount; ++i) {
                LinkedHashMap<String, Object> orderedItemValues = new LinkedHashMap<String, Object>();
                orderedItemValues.put("identifier", "PRD-" + faker.number().digits(8));
                orderedItemValues.put("name", faker.commerce().productName());
                int quantity = faker.number().numberBetween(1, 10);
                double price = faker.number().randomDouble(2, 10, 500);
                orderedItemValues.put("orderQuantity", quantity);
                orderedItemValues.put("price", price);
                totalPrice += (double)quantity * price;
                if (orderedItemSchema == null) continue;
                orderedItems[i] = new MapRecord(orderedItemSchema, orderedItemValues);
            }
            values.put("orderedItem", 2.generateNullableValue(nullPercentage, faker, f -> orderedItems));
            double finalTotal = totalPrice;
            values.put("totalPrice", 2.generateNullableValue(nullPercentage, faker, f -> BigDecimal.valueOf(finalTotal).setScale(2, RoundingMode.HALF_UP)));
            return values;
        }
    }
    ,
    EVENT("Event", "A timestamped event with metadata and keywords (schema.org/Event)"){

        @Override
        public RecordSchema getSchema(boolean nullable) {
            List<RecordField> fields = Arrays.asList(new RecordField("identifier", RecordFieldType.UUID.getDataType(), nullable), new RecordField("additionalType", RecordFieldType.STRING.getDataType(), nullable), new RecordField("startDate", RecordFieldType.DATE.getDataType(), nullable), new RecordField("startTime", RecordFieldType.TIME.getDataType(), nullable), new RecordField("endDate", RecordFieldType.TIMESTAMP.getDataType(), nullable), new RecordField("organizer", RecordFieldType.STRING.getDataType(), nullable), new RecordField("eventStatus", RecordFieldType.STRING.getDataType(), nullable), new RecordField("description", RecordFieldType.STRING.getDataType(), nullable), new RecordField("isAccessibleForFree", RecordFieldType.BOOLEAN.getDataType(), nullable), new RecordField("attendeeCount", RecordFieldType.INT.getDataType(), nullable), new RecordField("duration", RecordFieldType.LONG.getDataType(), nullable), new RecordField("keywords", RecordFieldType.ARRAY.getArrayDataType(RecordFieldType.STRING.getDataType()), nullable), new RecordField("additionalProperty", RecordFieldType.MAP.getMapDataType(RecordFieldType.STRING.getDataType()), nullable));
            return new SimpleRecordSchema(fields);
        }

        @Override
        public Map<String, Object> generateValues(Faker faker, RecordSchema schema, int nullPercentage) {
            LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            values.put("identifier", 3.generateNullableValue(nullPercentage, faker, f -> UUID.randomUUID()));
            values.put("additionalType", 3.generateNullableValue(nullPercentage, faker, f -> f.hacker().verb().toUpperCase() + "_" + f.hacker().noun().toUpperCase()));
            Instant eventInstant = faker.timeAndDate().past(30L, TimeUnit.DAYS);
            values.put("startDate", 3.generateNullableValue(nullPercentage, faker, f -> new Date(eventInstant.toEpochMilli())));
            values.put("startTime", 3.generateNullableValue(nullPercentage, faker, f -> new Time(eventInstant.toEpochMilli())));
            values.put("endDate", 3.generateNullableValue(nullPercentage, faker, f -> new Timestamp(eventInstant.toEpochMilli())));
            values.put("organizer", 3.generateNullableValue(nullPercentage, faker, f -> f.app().name().toLowerCase().replace(" ", "-")));
            String[] statuses = new String[]{"EventCancelled", "EventMovedOnline", "EventPostponed", "EventRescheduled", "EventScheduled"};
            values.put("eventStatus", 3.generateNullableValue(nullPercentage, faker, f -> statuses[f.number().numberBetween(0, statuses.length)]));
            values.put("description", 3.generateNullableValue(nullPercentage, faker, f -> f.lorem().sentence()));
            values.put("isAccessibleForFree", 3.generateNullableValue(nullPercentage, faker, f -> f.bool().bool()));
            values.put("attendeeCount", 3.generateNullableValue(nullPercentage, faker, f -> f.number().numberBetween(0, 5)));
            values.put("duration", 3.generateNullableValue(nullPercentage, faker, f -> f.number().numberBetween(1L, 10000L)));
            int keywordCount = faker.number().numberBetween(1, 4);
            String[] keywords = new String[keywordCount];
            for (int i = 0; i < keywordCount; ++i) {
                keywords[i] = faker.marketing().buzzwords().toLowerCase();
            }
            values.put("keywords", 3.generateNullableValue(nullPercentage, faker, f -> keywords));
            HashMap<String, String> additionalProperty = new HashMap<String, String>();
            additionalProperty.put("version", faker.app().version());
            additionalProperty.put("environment", faker.options().option(new String[]{"dev", "staging", "prod"}));
            additionalProperty.put("region", faker.aws().region());
            additionalProperty.put("correlationId", UUID.randomUUID().toString());
            values.put("additionalProperty", 3.generateNullableValue(nullPercentage, faker, f -> additionalProperty));
            return values;
        }
    }
    ,
    SENSOR("Sensor", "An IoT sensor reading with geo coordinates and measurements"){

        @Override
        public RecordSchema getSchema(boolean nullable) {
            List<RecordField> geoFields = Arrays.asList(new RecordField("latitude", RecordFieldType.DOUBLE.getDataType(), nullable), new RecordField("longitude", RecordFieldType.DOUBLE.getDataType(), nullable), new RecordField("elevation", RecordFieldType.DOUBLE.getDataType(), nullable));
            SimpleRecordSchema geoSchema = new SimpleRecordSchema(geoFields);
            List<RecordField> fields = Arrays.asList(new RecordField("identifier", RecordFieldType.STRING.getDataType(), nullable), new RecordField("additionalType", RecordFieldType.STRING.getDataType(), nullable), new RecordField("manufacturer", RecordFieldType.STRING.getDataType(), nullable), new RecordField("dateCreated", RecordFieldType.TIMESTAMP.getDataType(), nullable), new RecordField("temperature", RecordFieldType.DOUBLE.getDataType(), nullable), new RecordField("humidity", RecordFieldType.DOUBLE.getDataType(), nullable), new RecordField("pressure", RecordFieldType.DOUBLE.getDataType(), nullable), new RecordField("batteryLevel", RecordFieldType.INT.getDataType(), nullable), new RecordField("signalStrength", RecordFieldType.INT.getDataType(), nullable), new RecordField("isActive", RecordFieldType.BOOLEAN.getDataType(), nullable), new RecordField("geo", RecordFieldType.RECORD.getRecordDataType((RecordSchema)geoSchema), nullable));
            return new SimpleRecordSchema(fields);
        }

        @Override
        public Map<String, Object> generateValues(Faker faker, RecordSchema schema, int nullPercentage) {
            RecordSchema geoSchema;
            LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            values.put("identifier", 4.generateNullableValue(nullPercentage, faker, f -> f.device().serial()));
            values.put("additionalType", 4.generateNullableValue(nullPercentage, faker, f -> f.device().platform()));
            values.put("manufacturer", 4.generateNullableValue(nullPercentage, faker, f -> f.device().manufacturer()));
            values.put("dateCreated", 4.generateNullableValue(nullPercentage, faker, f -> new Timestamp(System.currentTimeMillis() - (long)f.number().numberBetween(0, 3600000))));
            values.put("temperature", 4.generateNullableValue(nullPercentage, faker, f -> f.number().randomDouble(2, -20, 45)));
            values.put("humidity", 4.generateNullableValue(nullPercentage, faker, f -> f.number().randomDouble(2, 0, 100)));
            values.put("pressure", 4.generateNullableValue(nullPercentage, faker, f -> f.number().randomDouble(2, 980, 1050)));
            values.put("batteryLevel", 4.generateNullableValue(nullPercentage, faker, f -> f.number().numberBetween(0, 100)));
            values.put("signalStrength", 4.generateNullableValue(nullPercentage, faker, f -> f.number().numberBetween(-100, -30)));
            values.put("isActive", 4.generateNullableValue(nullPercentage, faker, f -> f.bool().bool()));
            LinkedHashMap<String, Double> geoValues = new LinkedHashMap<String, Double>();
            geoValues.put("latitude", faker.number().randomDouble(6, -90, 90));
            geoValues.put("longitude", faker.number().randomDouble(6, -180, 180));
            geoValues.put("elevation", faker.number().randomDouble(2, 0, 3000));
            RecordSchema recordSchema = geoSchema = ((RecordField)schema.getField("geo").get()).getDataType().getFieldType() == RecordFieldType.RECORD ? ((RecordDataType)((RecordField)schema.getField("geo").get()).getDataType()).getChildSchema() : null;
            if (geoSchema != null) {
                values.put("geo", 4.generateNullableValue(nullPercentage, faker, f -> new MapRecord(geoSchema, geoValues)));
            }
            return values;
        }
    }
    ,
    PRODUCT("Product", "A product catalog entry with pricing and inventory (schema.org/Product)"){

        @Override
        public RecordSchema getSchema(boolean nullable) {
            List<RecordField> dimensionFields = Arrays.asList(new RecordField("depth", RecordFieldType.DOUBLE.getDataType(), nullable), new RecordField("width", RecordFieldType.DOUBLE.getDataType(), nullable), new RecordField("height", RecordFieldType.DOUBLE.getDataType(), nullable), new RecordField("weight", RecordFieldType.DOUBLE.getDataType(), nullable));
            SimpleRecordSchema dimensionSchema = new SimpleRecordSchema(dimensionFields);
            List<RecordField> fields = Arrays.asList(new RecordField("identifier", RecordFieldType.UUID.getDataType(), nullable), new RecordField("sku", RecordFieldType.STRING.getDataType(), nullable), new RecordField("name", RecordFieldType.STRING.getDataType(), nullable), new RecordField("description", RecordFieldType.STRING.getDataType(), nullable), new RecordField("category", RecordFieldType.STRING.getDataType(), nullable), new RecordField("brand", RecordFieldType.STRING.getDataType(), nullable), new RecordField("price", RecordFieldType.DECIMAL.getDecimalDataType(10, 2), nullable), new RecordField("priceCurrency", RecordFieldType.STRING.getDataType(), nullable), new RecordField("availability", RecordFieldType.BOOLEAN.getDataType(), nullable), new RecordField("inventoryLevel", RecordFieldType.INT.getDataType(), nullable), new RecordField("ratingValue", RecordFieldType.DOUBLE.getDataType(), nullable), new RecordField("reviewCount", RecordFieldType.INT.getDataType(), nullable), new RecordField("dateCreated", RecordFieldType.DATE.getDataType(), nullable), new RecordField("dateModified", RecordFieldType.TIMESTAMP.getDataType(), nullable), new RecordField("keywords", RecordFieldType.ARRAY.getArrayDataType(RecordFieldType.STRING.getDataType()), nullable), new RecordField("additionalProperty", RecordFieldType.RECORD.getRecordDataType((RecordSchema)dimensionSchema), nullable));
            return new SimpleRecordSchema(fields);
        }

        @Override
        public Map<String, Object> generateValues(Faker faker, RecordSchema schema, int nullPercentage) {
            RecordSchema dimensionSchema;
            LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            values.put("identifier", 5.generateNullableValue(nullPercentage, faker, f -> UUID.randomUUID()));
            values.put("sku", 5.generateNullableValue(nullPercentage, faker, f -> "SKU-" + f.number().digits(8)));
            values.put("name", 5.generateNullableValue(nullPercentage, faker, f -> f.commerce().productName()));
            values.put("description", 5.generateNullableValue(nullPercentage, faker, f -> f.lorem().paragraph()));
            values.put("category", 5.generateNullableValue(nullPercentage, faker, f -> f.commerce().department()));
            values.put("brand", 5.generateNullableValue(nullPercentage, faker, f -> f.commerce().brand()));
            values.put("price", 5.generateNullableValue(nullPercentage, faker, f -> BigDecimal.valueOf(f.number().randomDouble(2, 5, 2000)).setScale(2, RoundingMode.HALF_UP)));
            values.put("priceCurrency", 5.generateNullableValue(nullPercentage, faker, f -> f.money().currencyCode()));
            int inventoryLevel = faker.number().numberBetween(0, 500);
            values.put("availability", 5.generateNullableValue(nullPercentage, faker, f -> inventoryLevel > 0));
            values.put("inventoryLevel", 5.generateNullableValue(nullPercentage, faker, f -> inventoryLevel));
            values.put("ratingValue", 5.generateNullableValue(nullPercentage, faker, f -> f.number().randomDouble(1, 1, 5)));
            values.put("reviewCount", 5.generateNullableValue(nullPercentage, faker, f -> f.number().numberBetween(0, 5000)));
            values.put("dateCreated", 5.generateNullableValue(nullPercentage, faker, f -> new Date(f.timeAndDate().past(365L, TimeUnit.DAYS).toEpochMilli())));
            values.put("dateModified", 5.generateNullableValue(nullPercentage, faker, f -> new Timestamp(f.timeAndDate().past(30L, TimeUnit.DAYS).toEpochMilli())));
            int keywordCount = faker.number().numberBetween(0, 4);
            String[] keywords = new String[keywordCount];
            for (int i = 0; i < keywordCount; ++i) {
                keywords[i] = faker.marketing().buzzwords().toLowerCase();
            }
            values.put("keywords", 5.generateNullableValue(nullPercentage, faker, f -> keywords));
            LinkedHashMap<String, Double> dimensionValues = new LinkedHashMap<String, Double>();
            dimensionValues.put("depth", faker.number().randomDouble(2, 1, 100));
            dimensionValues.put("width", faker.number().randomDouble(2, 1, 100));
            dimensionValues.put("height", faker.number().randomDouble(2, 1, 100));
            dimensionValues.put("weight", faker.number().randomDouble(2, 1, 50));
            RecordSchema recordSchema = dimensionSchema = ((RecordField)schema.getField("additionalProperty").get()).getDataType().getFieldType() == RecordFieldType.RECORD ? ((RecordDataType)((RecordField)schema.getField("additionalProperty").get()).getDataType()).getChildSchema() : null;
            if (dimensionSchema != null) {
                values.put("additionalProperty", 5.generateNullableValue(nullPercentage, faker, f -> new MapRecord(dimensionSchema, dimensionValues)));
            }
            return values;
        }
    }
    ,
    STOCK_TRADE("Stock Trade", "A stock market trade with pricing and volume"){

        @Override
        public RecordSchema getSchema(boolean nullable) {
            List<RecordField> fields = Arrays.asList(new RecordField("identifier", RecordFieldType.UUID.getDataType(), nullable), new RecordField("tickerSymbol", RecordFieldType.STRING.getDataType(), nullable), new RecordField("name", RecordFieldType.STRING.getDataType(), nullable), new RecordField("exchange", RecordFieldType.STRING.getDataType(), nullable), new RecordField("actionType", RecordFieldType.STRING.getDataType(), nullable), new RecordField("dateCreated", RecordFieldType.TIMESTAMP.getDataType(), nullable), new RecordField("price", RecordFieldType.DECIMAL.getDecimalDataType(12, 4), nullable), new RecordField("orderQuantity", RecordFieldType.LONG.getDataType(), nullable), new RecordField("totalPrice", RecordFieldType.DECIMAL.getDecimalDataType(16, 2), nullable), new RecordField("priceCurrency", RecordFieldType.STRING.getDataType(), nullable), new RecordField("bidPrice", RecordFieldType.DECIMAL.getDecimalDataType(12, 4), nullable), new RecordField("askPrice", RecordFieldType.DECIMAL.getDecimalDataType(12, 4), nullable), new RecordField("highPrice", RecordFieldType.DECIMAL.getDecimalDataType(12, 4), nullable), new RecordField("lowPrice", RecordFieldType.DECIMAL.getDecimalDataType(12, 4), nullable), new RecordField("marketCap", RecordFieldType.LONG.getDataType(), nullable), new RecordField("isSettled", RecordFieldType.BOOLEAN.getDataType(), nullable));
            return new SimpleRecordSchema(fields);
        }

        @Override
        public Map<String, Object> generateValues(Faker faker, RecordSchema schema, int nullPercentage) {
            LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            values.put("identifier", 6.generateNullableValue(nullPercentage, faker, f -> UUID.randomUUID()));
            values.put("tickerSymbol", 6.generateNullableValue(nullPercentage, faker, f -> f.bool().bool() ? f.stock().nsdqSymbol() : f.stock().nyseSymbol()));
            values.put("name", 6.generateNullableValue(nullPercentage, faker, f -> f.company().name()));
            values.put("exchange", 6.generateNullableValue(nullPercentage, faker, f -> f.stock().exchanges()));
            String[] actionTypes = new String[]{"BuyAction", "SellAction"};
            values.put("actionType", 6.generateNullableValue(nullPercentage, faker, f -> actionTypes[f.number().numberBetween(0, actionTypes.length)]));
            values.put("dateCreated", 6.generateNullableValue(nullPercentage, faker, f -> new Timestamp(System.currentTimeMillis() - (long)f.number().numberBetween(0, 86400000))));
            double price = faker.number().randomDouble(4, 10, 3000);
            long orderQuantity = faker.number().numberBetween(1, 10000);
            values.put("price", 6.generateNullableValue(nullPercentage, faker, f -> BigDecimal.valueOf(price).setScale(4, RoundingMode.HALF_UP)));
            values.put("orderQuantity", 6.generateNullableValue(nullPercentage, faker, f -> orderQuantity));
            values.put("totalPrice", 6.generateNullableValue(nullPercentage, faker, f -> BigDecimal.valueOf(price * (double)orderQuantity).setScale(2, RoundingMode.HALF_UP)));
            values.put("priceCurrency", 6.generateNullableValue(nullPercentage, faker, f -> f.money().currencyCode()));
            values.put("bidPrice", 6.generateNullableValue(nullPercentage, faker, f -> BigDecimal.valueOf(price * 0.999).setScale(4, RoundingMode.HALF_UP)));
            values.put("askPrice", 6.generateNullableValue(nullPercentage, faker, f -> BigDecimal.valueOf(price * 1.001).setScale(4, RoundingMode.HALF_UP)));
            values.put("highPrice", 6.generateNullableValue(nullPercentage, faker, f -> BigDecimal.valueOf(price * 1.5).setScale(4, RoundingMode.HALF_UP)));
            values.put("lowPrice", 6.generateNullableValue(nullPercentage, faker, f -> BigDecimal.valueOf(price * 0.6).setScale(4, RoundingMode.HALF_UP)));
            values.put("marketCap", 6.generateNullableValue(nullPercentage, faker, f -> f.number().numberBetween(1000000000L, 3000000000000L)));
            values.put("isSettled", 6.generateNullableValue(nullPercentage, faker, f -> f.bool().bool()));
            return values;
        }
    }
    ,
    COMPLETE_EXAMPLE("Complete Example", "A comprehensive schema demonstrating all supported data types including nested records, arrays, and maps"){

        @Override
        public RecordSchema getSchema(boolean nullable) {
            List<RecordField> geoFields = Arrays.asList(new RecordField("latitude", RecordFieldType.DOUBLE.getDataType(), nullable), new RecordField("longitude", RecordFieldType.DOUBLE.getDataType(), nullable));
            SimpleRecordSchema geoSchema = new SimpleRecordSchema(geoFields);
            List<RecordField> addressFields = Arrays.asList(new RecordField("streetAddress", RecordFieldType.STRING.getDataType(), nullable), new RecordField("addressLocality", RecordFieldType.STRING.getDataType(), nullable), new RecordField("addressRegion", RecordFieldType.STRING.getDataType(), nullable), new RecordField("postalCode", RecordFieldType.STRING.getDataType(), nullable), new RecordField("addressCountry", RecordFieldType.STRING.getDataType(), nullable), new RecordField("geo", RecordFieldType.RECORD.getRecordDataType((RecordSchema)geoSchema), nullable));
            SimpleRecordSchema addressSchema = new SimpleRecordSchema(addressFields);
            List<RecordField> personFields = Arrays.asList(new RecordField("givenName", RecordFieldType.STRING.getDataType(), nullable), new RecordField("familyName", RecordFieldType.STRING.getDataType(), nullable), new RecordField("email", RecordFieldType.STRING.getDataType(), nullable), new RecordField("age", RecordFieldType.INT.getDataType(), nullable), new RecordField("verified", RecordFieldType.BOOLEAN.getDataType(), nullable), new RecordField("address", RecordFieldType.RECORD.getRecordDataType((RecordSchema)addressSchema), nullable));
            SimpleRecordSchema personSchema = new SimpleRecordSchema(personFields);
            List<RecordField> orderFields = Arrays.asList(new RecordField("orderNumber", RecordFieldType.STRING.getDataType(), nullable), new RecordField("totalPrice", RecordFieldType.DOUBLE.getDataType(), nullable), new RecordField("priceCurrency", RecordFieldType.STRING.getDataType(), nullable), new RecordField("orderDate", RecordFieldType.DATE.getDataType(), nullable), new RecordField("isGift", RecordFieldType.BOOLEAN.getDataType(), nullable));
            SimpleRecordSchema orderSchema = new SimpleRecordSchema(orderFields);
            List<RecordField> fields = Arrays.asList(new RecordField("identifier", RecordFieldType.UUID.getDataType(), nullable), new RecordField("isActive", RecordFieldType.BOOLEAN.getDataType(), nullable), new RecordField("score", RecordFieldType.INT.getDataType(), nullable), new RecordField("count", RecordFieldType.LONG.getDataType(), nullable), new RecordField("ratingValue", RecordFieldType.DOUBLE.getDataType(), nullable), new RecordField("price", RecordFieldType.FLOAT.getDataType(), nullable), new RecordField("balance", RecordFieldType.DECIMAL.getDecimalDataType(12, 2), nullable), new RecordField("initial", RecordFieldType.CHAR.getDataType(), nullable), new RecordField("flags", RecordFieldType.BYTE.getDataType(), nullable), new RecordField("position", RecordFieldType.SHORT.getDataType(), nullable), new RecordField("dateCreated", RecordFieldType.DATE.getDataType(), nullable), new RecordField("lastLogin", RecordFieldType.TIME.getDataType(), nullable), new RecordField("dateModified", RecordFieldType.TIMESTAMP.getDataType(), nullable), new RecordField("keywords", RecordFieldType.ARRAY.getArrayDataType(RecordFieldType.STRING.getDataType()), nullable), new RecordField("scores", RecordFieldType.ARRAY.getArrayDataType(RecordFieldType.INT.getDataType()), nullable), new RecordField("additionalProperty", RecordFieldType.MAP.getMapDataType(RecordFieldType.STRING.getDataType()), nullable), new RecordField("person", RecordFieldType.RECORD.getRecordDataType((RecordSchema)personSchema), nullable), new RecordField("orderedItem", RecordFieldType.ARRAY.getArrayDataType(RecordFieldType.RECORD.getRecordDataType((RecordSchema)orderSchema)), nullable));
            return new SimpleRecordSchema(fields);
        }

        @Override
        public Map<String, Object> generateValues(Faker faker, RecordSchema schema, int nullPercentage) {
            DataType elementType;
            RecordSchema personSchema;
            LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            values.put("identifier", 7.generateNullableValue(nullPercentage, faker, f -> UUID.randomUUID()));
            values.put("isActive", 7.generateNullableValue(nullPercentage, faker, f -> f.bool().bool()));
            values.put("score", 7.generateNullableValue(nullPercentage, faker, f -> f.number().numberBetween(0, 100)));
            values.put("count", 7.generateNullableValue(nullPercentage, faker, f -> f.number().numberBetween(0L, 1000000L)));
            values.put("ratingValue", 7.generateNullableValue(nullPercentage, faker, f -> f.number().randomDouble(2, 0, 5)));
            values.put("price", 7.generateNullableValue(nullPercentage, faker, f -> Float.valueOf((float)f.number().randomDouble(2, 1, 1000))));
            values.put("balance", 7.generateNullableValue(nullPercentage, faker, f -> BigDecimal.valueOf(f.number().randomDouble(2, -10000, 50000)).setScale(2, RoundingMode.HALF_UP)));
            values.put("initial", 7.generateNullableValue(nullPercentage, faker, f -> Character.valueOf((char)(65 + f.number().numberBetween(0, 26)))));
            values.put("flags", 7.generateNullableValue(nullPercentage, faker, f -> (byte)f.number().numberBetween(0, 127)));
            values.put("position", 7.generateNullableValue(nullPercentage, faker, f -> (short)f.number().numberBetween(1, 1000)));
            Instant pastInstant = faker.timeAndDate().past(365L, TimeUnit.DAYS);
            values.put("dateCreated", 7.generateNullableValue(nullPercentage, faker, f -> new Date(pastInstant.toEpochMilli())));
            values.put("lastLogin", 7.generateNullableValue(nullPercentage, faker, f -> new Time(f.timeAndDate().past(1L, TimeUnit.DAYS).toEpochMilli())));
            values.put("dateModified", 7.generateNullableValue(nullPercentage, faker, f -> new Timestamp(f.timeAndDate().past(7L, TimeUnit.DAYS).toEpochMilli())));
            int keywordCount = faker.number().numberBetween(1, 5);
            String[] keywords = new String[keywordCount];
            for (int i = 0; i < keywordCount; ++i) {
                keywords[i] = faker.word().adjective();
            }
            values.put("keywords", 7.generateNullableValue(nullPercentage, faker, f -> keywords));
            int scoreCount = faker.number().numberBetween(3, 8);
            Integer[] scores = new Integer[scoreCount];
            for (int i = 0; i < scoreCount; ++i) {
                scores[i] = faker.number().numberBetween(50, 100);
            }
            values.put("scores", 7.generateNullableValue(nullPercentage, faker, f -> scores));
            HashMap<String, String> additionalProperty = new HashMap<String, String>();
            additionalProperty.put("source", faker.app().name().toLowerCase().replace(" ", "-"));
            additionalProperty.put("version", faker.app().version());
            additionalProperty.put("environment", faker.options().option(new String[]{"dev", "staging", "prod"}));
            additionalProperty.put("region", faker.aws().region());
            values.put("additionalProperty", 7.generateNullableValue(nullPercentage, faker, f -> additionalProperty));
            RecordSchema recordSchema = personSchema = ((RecordField)schema.getField("person").get()).getDataType().getFieldType() == RecordFieldType.RECORD ? ((RecordDataType)((RecordField)schema.getField("person").get()).getDataType()).getChildSchema() : null;
            if (personSchema != null) {
                RecordSchema addressSchema;
                LinkedHashMap<String, Object> personValues = new LinkedHashMap<String, Object>();
                personValues.put("givenName", faker.name().firstName());
                personValues.put("familyName", faker.name().lastName());
                personValues.put("email", faker.internet().emailAddress());
                personValues.put("age", faker.number().numberBetween(18, 80));
                personValues.put("verified", faker.bool().bool());
                RecordSchema recordSchema2 = addressSchema = ((RecordField)personSchema.getField("address").get()).getDataType().getFieldType() == RecordFieldType.RECORD ? ((RecordDataType)((RecordField)personSchema.getField("address").get()).getDataType()).getChildSchema() : null;
                if (addressSchema != null) {
                    RecordSchema geoSchema;
                    LinkedHashMap<String, String> addressValues = new LinkedHashMap<String, String>();
                    addressValues.put("streetAddress", faker.address().streetAddress());
                    addressValues.put("addressLocality", faker.address().city());
                    addressValues.put("addressRegion", faker.address().state());
                    addressValues.put("postalCode", faker.address().zipCode());
                    addressValues.put("addressCountry", faker.address().country());
                    RecordSchema recordSchema3 = geoSchema = ((RecordField)addressSchema.getField("geo").get()).getDataType().getFieldType() == RecordFieldType.RECORD ? ((RecordDataType)((RecordField)addressSchema.getField("geo").get()).getDataType()).getChildSchema() : null;
                    if (geoSchema != null) {
                        LinkedHashMap<String, Double> geoValues = new LinkedHashMap<String, Double>();
                        geoValues.put("latitude", faker.number().randomDouble(6, -90, 90));
                        geoValues.put("longitude", faker.number().randomDouble(6, -180, 180));
                        addressValues.put("geo", (String)new MapRecord(geoSchema, geoValues));
                    }
                    personValues.put("address", new MapRecord(addressSchema, addressValues));
                }
                values.put("person", 7.generateNullableValue(nullPercentage, faker, f -> new MapRecord(personSchema, personValues)));
            }
            RecordSchema orderSchema = null;
            if (((RecordField)schema.getField("orderedItem").get()).getDataType().getFieldType() == RecordFieldType.ARRAY && (elementType = ((ArrayDataType)((RecordField)schema.getField("orderedItem").get()).getDataType()).getElementType()).getFieldType() == RecordFieldType.RECORD) {
                orderSchema = ((RecordDataType)elementType).getChildSchema();
            }
            if (orderSchema != null) {
                RecordSchema finalOrderSchema = orderSchema;
                int orderCount = faker.number().numberBetween(1, 4);
                Object[] orders = new Object[orderCount];
                for (int i = 0; i < orderCount; ++i) {
                    LinkedHashMap<String, Object> orderValues = new LinkedHashMap<String, Object>();
                    orderValues.put("orderNumber", "ORD-" + faker.number().digits(8));
                    orderValues.put("totalPrice", faker.number().randomDouble(2, 10, 500));
                    orderValues.put("priceCurrency", faker.money().currencyCode());
                    orderValues.put("orderDate", new Date(faker.timeAndDate().past(90L, TimeUnit.DAYS).toEpochMilli()));
                    orderValues.put("isGift", faker.bool().bool());
                    orders[i] = new MapRecord(finalOrderSchema, orderValues);
                }
                values.put("orderedItem", 7.generateNullableValue(nullPercentage, faker, f -> orders));
            }
            return values;
        }
    };

    private final String displayName;
    private final String description;

    private PredefinedRecordSchema(String displayName, String description) {
        this.displayName = displayName;
        this.description = description;
    }

    public String getValue() {
        return this.name();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract RecordSchema getSchema(boolean var1);

    public abstract Map<String, Object> generateValues(Faker var1, RecordSchema var2, int var3);

    public Record generateRecord(Faker faker, boolean nullable, int nullPercentage) {
        RecordSchema schema = this.getSchema(nullable);
        Map<String, Object> values = this.generateValues(faker, schema, nullPercentage);
        return new MapRecord(schema, values);
    }

    protected static <T> T generateNullableValue(int nullPercentage, Faker faker, Function<Faker, T> generator) {
        if (nullPercentage > 0 && faker.number().numberBetween(0, 100) < nullPercentage) {
            return null;
        }
        return generator.apply(faker);
    }

    public static PredefinedRecordSchema fromName(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        try {
            return PredefinedRecordSchema.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

