/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.db;

import org.apache.nifi.components.DescribedValue;

public enum TranslationStrategy implements DescribedValue
{
    REMOVE_UNDERSCORE("Remove Underscore", "Underscores '_' will be removed from column names Ex: 'Pics_1_23' becomes 'PICS123'"),
    REMOVE_SPACE("Remove Space", "Spaces will be removed from column names Ex. 'User Name' becomes 'USERNAME'"),
    REMOVE_UNDERSCORE_AND_SPACE("Remove Underscores and Spaces", "Spaces and Underscores will be removed from column names Ex. 'User_1 Name' becomes 'USER1NAME'"),
    REMOVE_ALL_SPECIAL_CHAR("Remove Regular Expression Characters", "Remove Regular Expression Characters Ex. 'user-id' becomes USERID ,total(estimated) become TOTALESTIMATED"),
    PATTERN("Regular Expression", "Remove characters matching this Regular Expression from the column names Ex.1. '\\d' will  Remove all numbers 2. '[^a-zA-Z0-9_]' will remove special characters except underscore");

    private final String displayName;
    private final String description;

    private TranslationStrategy(String displayName, String description) {
        this.displayName = displayName;
        this.description = description;
    }

    public String getValue() {
        return this.name();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }
}

