/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.behavior.DefaultRunDuration;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.metrics.CommitTiming;
import org.apache.nifi.processor.util.StandardValidators;

@SideEffectFree
@SupportsBatching(defaultDuration=DefaultRunDuration.TWENTY_FIVE_MILLIS)
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"gauge", "metrics", "instrumentation"})
@CapabilityDescription(value="Record the configured value of the named Gauge for each FlowFile processed.\nSupports instrumentation, debugging, and troubleshooting using Expression Language with FlowFile attributes.\n")
public class UpdateGauge
extends AbstractProcessor {
    static final PropertyDescriptor GAUGE_NAME = new PropertyDescriptor.Builder().name("Gauge Name").description("Name of the Gauge to be recorded for each FlowFile processed").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).addValidator(StandardValidators.ATTRIBUTE_EXPRESSION_LANGUAGE_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final PropertyDescriptor GAUGE_VALUE = new PropertyDescriptor.Builder().name("Gauge Value").description("Numeric value of the Gauge to be recorded for each FlowFile processed").required(true).addValidator(StandardValidators.NUMBER_VALIDATOR).addValidator(StandardValidators.ATTRIBUTE_EXPRESSION_LANGUAGE_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final Relationship SUCCESS = new Relationship.Builder().name("success").description("FlowFile processing completed with Gauge Value recorded").build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(GAUGE_NAME, GAUGE_VALUE);
    private static final Set<Relationship> RELATIONSHIPS = Set.of(SUCCESS);
    private static final double NULL_GAUGE_VALUE = 0.0;

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String gaugeName = context.getProperty(GAUGE_NAME).evaluateAttributeExpressions(flowFile).getValue();
        PropertyValue gaugeValueProperty = context.getProperty(GAUGE_VALUE).evaluateAttributeExpressions(flowFile);
        double gaugeValue = this.getGaugeValue(gaugeValueProperty);
        session.recordGauge(gaugeName, gaugeValue, CommitTiming.SESSION_COMMITTED);
        session.transfer(flowFile, SUCCESS);
    }

    private double getGaugeValue(PropertyValue gaugeValueProperty) {
        try {
            return gaugeValueProperty.asDouble();
        }
        catch (Exception e) {
            this.getLogger().warn("Failed to read Gauge Value as number", (Throwable)e);
            return 0.0;
        }
    }
}

