/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.database.dialect.service.api.ColumnDefinition;
import org.apache.nifi.database.dialect.service.api.DatabaseDialectService;
import org.apache.nifi.database.dialect.service.api.StandardColumnDefinition;
import org.apache.nifi.database.dialect.service.api.StandardStatementRequest;
import org.apache.nifi.database.dialect.service.api.StatementRequest;
import org.apache.nifi.database.dialect.service.api.StatementResponse;
import org.apache.nifi.database.dialect.service.api.StatementType;
import org.apache.nifi.database.dialect.service.api.TableDefinition;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processor.util.pattern.DiscontinuedException;
import org.apache.nifi.processors.standard.db.ColumnDescription;
import org.apache.nifi.processors.standard.db.DatabaseAdapterDescriptor;
import org.apache.nifi.processors.standard.db.NameNormalizer;
import org.apache.nifi.processors.standard.db.NameNormalizerFactory;
import org.apache.nifi.processors.standard.db.TableNotFoundException;
import org.apache.nifi.processors.standard.db.TableSchema;
import org.apache.nifi.processors.standard.db.TranslationStrategy;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.apache.nifi.util.StringUtils;

@Tags(value={"metadata", "jdbc", "database", "table", "update", "alter"})
@CapabilityDescription(value="This processor uses a JDBC connection and incoming records to generate any database table changes needed to support the incoming records. It expects a 'flat' record layout, meaning none of the top-level record fields has nested fields that are intended to become columns themselves.")
@WritesAttributes(value={@WritesAttribute(attribute="output.table", description="This attribute is written on the flow files routed to the 'success' and 'failure' relationships, and contains the target table name."), @WritesAttribute(attribute="output.path", description="This attribute is written on the flow files routed to the 'success' and 'failure' relationships, and contains the path on the file system to the table (or partition location if the table is partitioned)."), @WritesAttribute(attribute="mime.type", description="Sets the mime.type attribute to the MIME Type specified by the Record Writer, only if a Record Writer is specified and Update Field Names is 'true'."), @WritesAttribute(attribute="record.count", description="Sets the number of records in the FlowFile, only if a Record Writer is specified and Update Field Names is 'true'.")})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
public class UpdateDatabaseTable
extends AbstractProcessor {
    static final AllowableValue CREATE_IF_NOT_EXISTS = new AllowableValue("Create If Not Exists", "Create If Not Exists", "Create a table with the given schema if it does not already exist");
    static final AllowableValue FAIL_IF_NOT_EXISTS = new AllowableValue("Fail If Not Exists", "Fail If Not Exists", "If the target does not already exist, log an error and route the flowfile to failure");
    static final String ATTR_OUTPUT_TABLE = "output.table";
    static final PropertyDescriptor RECORD_READER = new PropertyDescriptor.Builder().name("Record Reader").description("The service for reading incoming flow files. The reader is only used to determine the schema of the records, the actual records will not be processed.").identifiesControllerService(RecordReaderFactory.class).required(true).build();
    static final PropertyDescriptor DBCP_SERVICE = new PropertyDescriptor.Builder().name("Database Connection Pooling Service").description("The Controller Service that is used to obtain connection(s) to the database").required(true).identifiesControllerService(DBCPService.class).build();
    static final PropertyDescriptor CATALOG_NAME = new PropertyDescriptor.Builder().name("Catalog Name").description("The name of the catalog that the statement should update. This may not apply for the database that you are updating. In this case, leave the field empty. Note that if the property is set and the database is case-sensitive, the catalog name must match the database's catalog name exactly.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor SCHEMA_NAME = new PropertyDescriptor.Builder().name("Schema Name").description("The name of the database schema that the table belongs to. This may not apply for the database that you are updating. In this case, leave the field empty. Note that if the property is set and the database is case-sensitive, the schema name must match the database's schema name exactly.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor TABLE_NAME = new PropertyDescriptor.Builder().name("Table Name").description("The name of the database table to update. If the table does not exist, then it will either be created or an error thrown, depending on the value of the Create Table property.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor CREATE_TABLE = new PropertyDescriptor.Builder().name("Create Table Strategy").description("Specifies how to process the target table when it does not exist (create it, fail, e.g.).").required(true).addValidator(Validator.VALID).allowableValues(new DescribedValue[]{CREATE_IF_NOT_EXISTS, FAIL_IF_NOT_EXISTS}).defaultValue((DescribedValue)FAIL_IF_NOT_EXISTS).build();
    static final PropertyDescriptor PRIMARY_KEY_FIELDS = new PropertyDescriptor.Builder().name("Primary Key Fields").description("A comma-separated list of record field names that uniquely identifies a row in the database. This property is only used if the specified table needs to be created, in which case the Primary Key Fields will be used to specify the primary keys of the newly-created table. IMPORTANT: Primary Key Fields must match the record field names exactly unless 'Quote Column Identifiers' is false and the database allows for case-insensitive column names. In practice it is best to specify Primary Key Fields that exactly match the record field names, and those will become the column names in the created table.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dependsOn(CREATE_TABLE, new AllowableValue[]{CREATE_IF_NOT_EXISTS}).build();
    static final PropertyDescriptor TRANSLATE_FIELD_NAMES = new PropertyDescriptor.Builder().name("Translate Field Names").description("If true, the Processor will attempt to translate field names into the corresponding column names for the table specified, for the purposes of determining whether the field name exists as a column in the target table. NOTE: If the target table does not exist and is to be created, this property is ignored and the field names will be used as-is. If false, the field names must match the column names exactly, or the column may not be found and instead an error my be reported that the column already exists.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    public static final PropertyDescriptor TRANSLATION_STRATEGY = new PropertyDescriptor.Builder().required(true).name("Column Name Translation Strategy").description("The strategy used to normalize table column name. Column Name will be uppercased to do case-insensitive matching irrespective of strategy").allowableValues(TranslationStrategy.class).defaultValue((DescribedValue)TranslationStrategy.REMOVE_UNDERSCORE).dependsOn(TRANSLATE_FIELD_NAMES, "true", new String[0]).build();
    public static final PropertyDescriptor TRANSLATION_PATTERN = new PropertyDescriptor.Builder().name("Column Name Translation Pattern").description("Column name will be normalized with this regular expression").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).dependsOn(TRANSLATION_STRATEGY, (DescribedValue)TranslationStrategy.PATTERN, new DescribedValue[0]).build();
    static final PropertyDescriptor UPDATE_FIELD_NAMES = new PropertyDescriptor.Builder().name("Update Field Names").description("This property indicates whether to update the output schema such that the field names are set to the exact column names from the specified table. This should be used if the incoming record field names may not match the table's column names in terms of upper- and lower-case. For example, this property should be set to true if the output FlowFile is destined for Oracle e.g., which expects the field names to match the column names exactly. NOTE: The value of the 'Translate Field Names' property is ignored when updating field names; instead they are updated to match the column name as returned by the database.").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    static final PropertyDescriptor RECORD_WRITER_FACTORY = new PropertyDescriptor.Builder().name("Record Writer").description("Specifies the Controller Service to use for writing results to a FlowFile. The Record Writer should use Inherit Schema to emulate the inferred schema behavior, i.e. an explicit schema need not be defined in the writer, and will be supplied by the same logic used to infer the schema from the column types. If Create Table Strategy is set 'Create If Not Exists', the Record Writer's output format must match the Record Reader's format in order for the data to be placed in the created table location. Note that this property is only used if 'Update Field Names' is set to true and the field names do not all match the column names exactly. If no update is needed for any field names (or 'Update Field Names' is false), the Record Writer is not used and instead the input FlowFile is routed to success or failure without modification.").identifiesControllerService(RecordSetWriterFactory.class).dependsOn(UPDATE_FIELD_NAMES, "true", new String[0]).required(true).build();
    static final PropertyDescriptor QUOTE_COLUMN_IDENTIFIERS = new PropertyDescriptor.Builder().name("Quote Column Identifiers").description("Enabling this option will cause all column names to be quoted, allowing you to use reserved words as column names in your tables and/or forcing the record field names to match the column names exactly.").allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    static final PropertyDescriptor QUOTE_TABLE_IDENTIFIER = new PropertyDescriptor.Builder().name("Quote Table Identifiers").description("Enabling this option will cause the table name to be quoted to support the use of special characters in the table name and/or forcing the value of the Table Name property to match the target table name exactly.").allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    static final PropertyDescriptor QUERY_TIMEOUT = new PropertyDescriptor.Builder().name("Query Timeout").description("Sets the number of seconds the driver will wait for a query to execute. A value of 0 means no timeout. NOTE: Non-zero values may not be supported by the driver.").defaultValue("0").required(true).addValidator(StandardValidators.INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final PropertyDescriptor DB_TYPE = DatabaseAdapterDescriptor.getDatabaseTypeDescriptor();
    static final PropertyDescriptor DATABASE_DIALECT_SERVICE = DatabaseAdapterDescriptor.getDatabaseDialectServiceDescriptor(DB_TYPE);
    private static final List<PropertyDescriptor> properties;
    public static final Relationship REL_SUCCESS;
    public static final Relationship REL_FAILURE;
    protected static Set<Relationship> relationships;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        boolean recordWriterFactorySet = validationContext.getProperty(RECORD_WRITER_FACTORY).isSet();
        boolean updateFieldNames = validationContext.getProperty(UPDATE_FIELD_NAMES).asBoolean();
        if (!recordWriterFactorySet && updateFieldNames) {
            validationResults.add(new ValidationResult.Builder().subject(RECORD_WRITER_FACTORY.getDisplayName()).explanation("Record Writer must be set if 'Update Field Names' is true").valid(false).build());
        }
        return validationResults;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        boolean translateFieldNames = context.getProperty(TRANSLATE_FIELD_NAMES).asBoolean();
        boolean updateFieldNames = context.getProperty(UPDATE_FIELD_NAMES).asBoolean();
        boolean createIfNotExists = context.getProperty(CREATE_TABLE).getValue().equals(CREATE_IF_NOT_EXISTS.getValue());
        RecordReaderFactory recordReaderFactory = (RecordReaderFactory)context.getProperty(RECORD_READER).asControllerService(RecordReaderFactory.class);
        RecordSetWriterFactory recordWriterFactory = updateFieldNames ? (RecordSetWriterFactory)context.getProperty(RECORD_WRITER_FACTORY).asControllerService(RecordSetWriterFactory.class) : null;
        String catalogName = context.getProperty(CATALOG_NAME).evaluateAttributeExpressions(flowFile).getValue();
        String schemaName = context.getProperty(SCHEMA_NAME).evaluateAttributeExpressions(flowFile).getValue();
        String tableName = context.getProperty(TABLE_NAME).evaluateAttributeExpressions(flowFile).getValue();
        String primaryKeyFields = createIfNotExists ? context.getProperty(PRIMARY_KEY_FIELDS).evaluateAttributeExpressions(flowFile).getValue() : null;
        ComponentLog log = this.getLogger();
        try {
            NameNormalizer normalizer;
            RecordReader reader;
            try (InputStream in2 = session.read(flowFile);){
                try {
                    reader = recordReaderFactory.createRecordReader(flowFile, in2, this.getLogger());
                }
                catch (Exception e) {
                    throw new ProcessException("Unable to create RecordReader", (Throwable)e);
                }
            }
            catch (ProcessException rrfe) {
                log.error("Failed to create {} for {} - routing to failure", new Object[]{RecordReader.class.getSimpleName(), flowFile, rrfe});
                Throwable c = rrfe.getCause();
                if (c != null) {
                    session.putAttribute(flowFile, "record.error.message", (String)(c.getLocalizedMessage() != null ? c.getLocalizedMessage() : c.getClass().getCanonicalName() + " Thrown"));
                } else {
                    session.putAttribute(flowFile, "record.error.message", ((Object)((Object)rrfe)).getClass().getCanonicalName() + " Thrown");
                }
                session.transfer(flowFile, REL_FAILURE);
                return;
            }
            RecordSchema recordSchema = reader.getSchema();
            if (translateFieldNames) {
                TranslationStrategy translationStrategy = (TranslationStrategy)context.getProperty(TRANSLATION_STRATEGY).asAllowableValue(TranslationStrategy.class);
                Pattern translationPattern = translationStrategy == TranslationStrategy.PATTERN ? Pattern.compile(context.getProperty(TRANSLATION_PATTERN).getValue()) : null;
                normalizer = NameNormalizerFactory.getNormalizer(translationStrategy, translationPattern);
            } else {
                normalizer = null;
            }
            if (recordWriterFactory == null && updateFieldNames) {
                throw new ProcessException("Record Writer must be set if 'Update Field Names' is true");
            }
            DBCPService dbcpService = (DBCPService)context.getProperty(DBCP_SERVICE).asControllerService(DBCPService.class);
            String databaseType = context.getProperty(DB_TYPE).getValue();
            DatabaseDialectService databaseDialectService = DatabaseAdapterDescriptor.getDatabaseDialectService((PropertyContext)context, DATABASE_DIALECT_SERVICE, databaseType);
            Connection connection = dbcpService.getConnection(flowFile.getAttributes());
            try {
                HashSet<String> primaryKeyColumnNames;
                boolean quoteTableName = context.getProperty(QUOTE_TABLE_IDENTIFIER).asBoolean();
                boolean quoteColumnNames = context.getProperty(QUOTE_COLUMN_IDENTIFIERS).asBoolean();
                HashMap<String, String> attributes = new HashMap<String, String>(flowFile.getAttributes());
                if (createIfNotExists && primaryKeyFields != null) {
                    primaryKeyColumnNames = new HashSet<String>();
                    Arrays.stream(primaryKeyFields.split(",")).filter(path -> path != null && !path.isBlank()).map(String::trim).forEach(primaryKeyColumnNames::add);
                } else {
                    primaryKeyColumnNames = null;
                }
                OutputMetadataHolder outputMetadataHolder = this.checkAndUpdateTableSchema(connection, databaseDialectService, recordSchema, catalogName, schemaName, tableName, createIfNotExists, translateFieldNames, normalizer, updateFieldNames, primaryKeyColumnNames, quoteTableName, quoteColumnNames);
                if (outputMetadataHolder != null) {
                    try {
                        FlowFile inputFlowFile = flowFile;
                        flowFile = session.write(flowFile, (in, out) -> {
                            RecordSetWriter recordSetWriter;
                            RecordReader recordReader;
                            try {
                                recordReader = recordReaderFactory.createRecordReader(inputFlowFile, in, this.getLogger());
                                recordSetWriter = recordWriterFactory.createWriter(this.getLogger(), outputMetadataHolder.getOutputSchema(), out, attributes);
                            }
                            catch (Exception e) {
                                if (e instanceof IOException) {
                                    throw (IOException)e;
                                }
                                throw new IOException("Unable to create RecordReader", e);
                            }
                            WriteResult writeResult = this.updateRecords(recordSchema, outputMetadataHolder, recordReader, recordSetWriter);
                            recordSetWriter.flush();
                            recordSetWriter.close();
                            attributes.put("record.count", String.valueOf(writeResult.getRecordCount()));
                            attributes.put(CoreAttributes.MIME_TYPE.key(), recordSetWriter.getMimeType());
                            attributes.putAll(writeResult.getAttributes());
                        });
                    }
                    catch (Exception e) {
                        this.getLogger().error("Failed to process {}; will route to failure", new Object[]{flowFile, e});
                        Throwable c = e.getCause();
                        if (c != null) {
                            session.putAttribute(flowFile, "record.error.message", (String)(c.getLocalizedMessage() != null ? c.getLocalizedMessage() : c.getClass().getCanonicalName() + " Thrown"));
                        } else {
                            session.putAttribute(flowFile, "record.error.message", e.getClass().getCanonicalName() + " Thrown");
                        }
                        session.transfer(flowFile, REL_FAILURE);
                        if (connection != null) {
                            connection.close();
                        }
                        return;
                    }
                }
                attributes.put(ATTR_OUTPUT_TABLE, tableName);
                flowFile = session.putAllAttributes(flowFile, attributes);
                session.getProvenanceReporter().invokeRemoteProcess(flowFile, this.getJdbcUrl(connection));
                session.transfer(flowFile, REL_SUCCESS);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (IOException | SQLException e) {
            flowFile = session.putAttribute(flowFile, ATTR_OUTPUT_TABLE, tableName);
            log.error("Exception while processing {} - routing to failure", new Object[]{flowFile, e});
            session.transfer(flowFile, REL_FAILURE);
        }
        catch (DiscontinuedException e) {
            this.getLogger().warn("Discontinued processing for {} due to {}", new Object[]{flowFile, e, e});
            session.transfer(flowFile, Relationship.SELF);
        }
        catch (Throwable t) {
            throw t instanceof ProcessException ? (ProcessException)t : new ProcessException(t);
        }
    }

    public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("record-reader", RECORD_READER.getName());
        config.renameProperty("db-type", DB_TYPE.getName());
        config.renameProperty("updatedatabasetable-dbcp-service", DBCP_SERVICE.getName());
        config.renameProperty("updatedatabasetable-catalog-name", CATALOG_NAME.getName());
        config.renameProperty("updatedatabasetable-schema-name", SCHEMA_NAME.getName());
        config.renameProperty("updatedatabasetable-table-name", TABLE_NAME.getName());
        config.renameProperty("updatedatabasetable-create-table", CREATE_TABLE.getName());
        config.renameProperty("updatedatabasetable-primary-keys", PRIMARY_KEY_FIELDS.getName());
        config.renameProperty("updatedatabasetable-translate-field-names", TRANSLATE_FIELD_NAMES.getName());
        config.renameProperty("updatedatabasetable-update-field-names", UPDATE_FIELD_NAMES.getName());
        config.renameProperty("updatedatabasetable-record-writer", RECORD_WRITER_FACTORY.getName());
        config.renameProperty("updatedatabasetable-quoted-column-identifiers", QUOTE_COLUMN_IDENTIFIERS.getName());
        config.renameProperty("updatedatabasetable-quoted-table-identifiers", QUOTE_TABLE_IDENTIFIER.getName());
        config.renameProperty("updatedatabasetable-query-timeout", QUERY_TIMEOUT.getName());
    }

    /*
     * WARNING - void declaration
     */
    private synchronized OutputMetadataHolder checkAndUpdateTableSchema(Connection conn, DatabaseDialectService databaseDialectService, RecordSchema schema, String catalogName, String schemaName, String tableName, boolean createIfNotExists, boolean translateFieldNames, NameNormalizer normalizer, boolean updateFieldNames, Set<String> primaryKeyColumnNames, boolean quoteTableName, boolean quoteColumnNames) throws IOException {
        void var23_37;
        block24: {
            Statement s = conn.createStatement();
            try {
                void var22_35;
                DatabaseMetaData databaseMetaData = conn.getMetaData();
                String quoteString = databaseMetaData.getIdentifierQuoteString();
                TableSchema tableSchema = null;
                try {
                    tableSchema = TableSchema.from(conn, catalogName, schemaName, tableName, translateFieldNames, normalizer, null, this.getLogger());
                }
                catch (TableNotFoundException tableNotFoundException) {
                    // empty catch block
                }
                ArrayList<ColumnDescription> columns = new ArrayList<ColumnDescription>();
                boolean tableCreated = false;
                if (tableSchema == null) {
                    if (createIfNotExists) {
                        String string;
                        Object quotedSchemaName;
                        for (RecordField recordField : schema.getFields()) {
                            String string2 = recordField.getFieldName();
                            boolean required = recordField.getDefaultValue() != null;
                            String columnName = translateFieldNames ? normalizer.getNormalizedName(string2) : string2;
                            int dataType = DataTypeUtils.getSQLTypeValue((DataType)recordField.getDataType());
                            String quotedColumnName = this.enquoteIdentifier(columnName, quoteString, quoteColumnNames);
                            columns.add(new ColumnDescription(quotedColumnName, dataType, required, null, recordField.isNullable()));
                            this.getLogger().debug("Adding column {} to table {}", new Object[]{columnName, tableName});
                        }
                        String quotedCatalogName = this.enquoteIdentifier(catalogName, quoteString, quoteTableName);
                        tableSchema = new TableSchema(quotedCatalogName, (String)(quotedSchemaName = this.enquoteIdentifier(schemaName, quoteString, quoteTableName)), string = this.enquoteIdentifier(tableName, quoteString, quoteTableName), columns, translateFieldNames, normalizer, primaryKeyColumnNames, quoteString);
                        TableDefinition tableDefinition = this.getTableDefinition(tableSchema);
                        StandardStatementRequest statementRequest = new StandardStatementRequest(StatementType.CREATE, tableDefinition);
                        StatementResponse statementResponse = databaseDialectService.getStatement((StatementRequest)statementRequest);
                        String createTableSql = statementResponse.sql();
                        if (StringUtils.isNotEmpty((String)createTableSql)) {
                            this.getLogger().info("Executing DDL: {}", new Object[]{createTableSql});
                            s.execute(createTableSql);
                        }
                        tableCreated = true;
                    } else {
                        throw new IOException("The table " + tableName + " could not be found in the database and the processor is configured not to create it.");
                    }
                }
                ArrayList<String> dbColumns = new ArrayList<String>();
                for (ColumnDescription columnDescription2 : tableSchema.getColumnsAsList()) {
                    dbColumns.add(TableSchema.normalizedName(columnDescription2.getColumnName(), translateFieldNames, normalizer));
                }
                ArrayList<ColumnDescription> columnsToAdd = new ArrayList<ColumnDescription>();
                if (!tableCreated) {
                    for (RecordField recordField : schema.getFields()) {
                        String recordFieldName = recordField.getFieldName();
                        String normalizedFieldName = TableSchema.normalizedName(recordFieldName, translateFieldNames, normalizer);
                        if (dbColumns.contains(normalizedFieldName)) continue;
                        ColumnDescription columnToAdd = new ColumnDescription(normalizedFieldName, DataTypeUtils.getSQLTypeValue((DataType)recordField.getDataType()), recordField.getDefaultValue() != null, null, recordField.isNullable());
                        columnsToAdd.add(columnToAdd);
                        dbColumns.add(recordFieldName);
                        this.getLogger().debug("Adding column {} to table {}", new Object[]{recordFieldName, tableName});
                    }
                    if (!columnsToAdd.isEmpty()) {
                        List<ColumnDefinition> list = columnsToAdd.stream().map(columnDescription -> new StandardColumnDefinition(this.enquoteIdentifier(columnDescription.getColumnName(), quoteString, quoteColumnNames), columnDescription.getDataType(), columnDescription.isNullable() ? ColumnDefinition.Nullable.YES : ColumnDefinition.Nullable.UNKNOWN, columnDescription.isRequired())).map(ColumnDefinition.class::cast).toList();
                        String qualifiedTableName = this.enquoteIdentifier(tableName, quoteString, quoteTableName);
                        TableDefinition tableDefinition = new TableDefinition(Optional.empty(), Optional.empty(), qualifiedTableName, list);
                        StandardStatementRequest statementRequest = new StandardStatementRequest(StatementType.ALTER, tableDefinition);
                        StatementResponse statementResponse = databaseDialectService.getStatement((StatementRequest)statementRequest);
                        this.getLogger().info("Executing DDL: {}", new Object[]{statementResponse.sql()});
                        s.execute(statementResponse.sql());
                    }
                }
                if (updateFieldNames) {
                    List inputRecordFields = schema.getFields();
                    ArrayList<RecordField> outputRecordFields = new ArrayList<RecordField>();
                    HashMap<String, String> fieldMap = new HashMap<String, String>();
                    boolean needsUpdating = false;
                    for (RecordField inputRecordField : inputRecordFields) {
                        String inputRecordFieldName = inputRecordField.getFieldName();
                        boolean found = false;
                        for (String columnName : dbColumns) {
                            if (!inputRecordFieldName.equalsIgnoreCase(columnName)) continue;
                            if (!inputRecordFieldName.equals(columnName)) {
                                needsUpdating = true;
                            }
                            fieldMap.put(inputRecordFieldName, columnName);
                            outputRecordFields.add(new RecordField(columnName, inputRecordField.getDataType(), inputRecordField.getDefaultValue(), inputRecordField.isNullable()));
                            found = true;
                            break;
                        }
                        if (found) continue;
                        fieldMap.put(inputRecordFieldName, inputRecordFieldName);
                    }
                    OutputMetadataHolder outputMetadataHolder = needsUpdating ? new OutputMetadataHolder((RecordSchema)new SimpleRecordSchema(outputRecordFields), fieldMap) : null;
                } else {
                    Object var22_34 = null;
                }
                var23_37 = var22_35;
                if (s == null) break block24;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            s.close();
        }
        return var23_37;
    }

    private synchronized WriteResult updateRecords(RecordSchema inputRecordSchema, OutputMetadataHolder outputMetadataHolder, RecordReader reader, RecordSetWriter writer) throws IOException {
        try {
            Record inputRecord;
            writer.beginRecordSet();
            while ((inputRecord = reader.nextRecord()) != null) {
                List inputRecordFields = inputRecordSchema.getFields();
                HashMap<String, Object> outputRecordFields = new HashMap<String, Object>(inputRecordFields.size());
                for (Map.Entry<String, String> mapping : outputMetadataHolder.getFieldMap().entrySet()) {
                    outputRecordFields.put(mapping.getValue(), inputRecord.getValue(mapping.getKey()));
                }
                MapRecord outputRecord = new MapRecord(outputMetadataHolder.getOutputSchema(), outputRecordFields);
                writer.write((Record)outputRecord);
            }
            return writer.finishRecordSet();
        }
        catch (MalformedRecordException mre) {
            throw new IOException("Error reading records: " + mre.getMessage(), mre);
        }
    }

    private String getJdbcUrl(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (databaseMetaData != null) {
                return databaseMetaData.getURL();
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Could not determine JDBC URL based on the Driver Connection.", (Throwable)e);
        }
        return "DBCPService";
    }

    private TableDefinition getTableDefinition(TableSchema tableSchema) {
        Set<String> primaryKeyColumnNames = tableSchema.getPrimaryKeyColumnNames();
        Set<Object> primaryKeys = primaryKeyColumnNames == null ? Set.of() : primaryKeyColumnNames;
        List<ColumnDefinition> columnDefinitions = tableSchema.getColumnsAsList().stream().map(columnDescription -> new StandardColumnDefinition(columnDescription.getColumnName(), columnDescription.getDataType(), columnDescription.isNullable() ? ColumnDefinition.Nullable.YES : ColumnDefinition.Nullable.NO, primaryKeys.contains(columnDescription.getColumnName()))).map(ColumnDefinition.class::cast).toList();
        return new TableDefinition(Optional.ofNullable(tableSchema.getCatalogName()), Optional.ofNullable(tableSchema.getSchemaName()), tableSchema.getTableName(), columnDefinitions);
    }

    private String enquoteIdentifier(String identifier, String quotedIdentifierString, boolean quoteIdentifier) {
        if (identifier != null && quoteIdentifier) {
            return quotedIdentifierString + identifier + quotedIdentifierString;
        }
        return identifier;
    }

    static {
        REL_SUCCESS = new Relationship.Builder().name("success").description("A FlowFile containing records routed to this relationship after the record has been successfully transmitted to the database.").build();
        REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile containing records routed to this relationship if the record could not be transmitted to the database.").build();
        relationships = Set.of(REL_SUCCESS, REL_FAILURE);
        properties = List.of(RECORD_READER, DBCP_SERVICE, DB_TYPE, DATABASE_DIALECT_SERVICE, CATALOG_NAME, SCHEMA_NAME, TABLE_NAME, CREATE_TABLE, PRIMARY_KEY_FIELDS, TRANSLATE_FIELD_NAMES, TRANSLATION_STRATEGY, TRANSLATION_PATTERN, UPDATE_FIELD_NAMES, RECORD_WRITER_FACTORY, QUOTE_TABLE_IDENTIFIER, QUOTE_COLUMN_IDENTIFIERS, QUERY_TIMEOUT);
    }

    private static class OutputMetadataHolder {
        private final RecordSchema outputSchema;
        private final Map<String, String> fieldMap;

        public OutputMetadataHolder(RecordSchema outputSchema, Map<String, String> fieldMap) {
            this.outputSchema = outputSchema;
            this.fieldMap = fieldMap;
        }

        public RecordSchema getOutputSchema() {
            return this.outputSchema;
        }

        public Map<String, String> getFieldMap() {
            return this.fieldMap;
        }
    }
}

