/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.Strings;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.flowfile.attributes.FragmentAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.AbstractJsonPathProcessor;

@SideEffectFree
@SupportsBatching
@Tags(value={"json", "split", "jsonpath"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Splits a JSON File into multiple, separate FlowFiles for an array element specified by a JsonPath expression. Each generated FlowFile is comprised of an element of the specified array and transferred to relationship 'split,' with the original file transferred to the 'original' relationship. If the specified JsonPath is not found or does not evaluate to an array element, the original file is routed to 'failure' and no files are generated.")
@WritesAttributes(value={@WritesAttribute(attribute="fragment.identifier", description="All split FlowFiles produced from the same parent FlowFile will have the same randomly generated UUID added for this attribute"), @WritesAttribute(attribute="fragment.index", description="A one-up number that indicates the ordering of the split FlowFiles that were created from a single parent FlowFile"), @WritesAttribute(attribute="fragment.count", description="The number of split FlowFiles generated from the parent FlowFile"), @WritesAttribute(attribute="segment.original.filename ", description="The filename of the parent FlowFile")})
@SystemResourceConsideration(resource=SystemResource.MEMORY, description="The entirety of the FlowFile's content (as a JsonNode object) is read into memory, in addition to all of the generated FlowFiles representing the split JSON. If many splits are generated due to the size of the JSON, or how the JSON is configured to be split, a two-phase approach may be necessary to avoid excessive use of memory.")
public class SplitJson
extends AbstractJsonPathProcessor {
    public static final PropertyDescriptor ARRAY_JSON_PATH_EXPRESSION = new PropertyDescriptor.Builder().name("JsonPath Expression").description("A JsonPath expression that indicates the array element to split into JSON/scalar fragments.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(ARRAY_JSON_PATH_EXPRESSION, NULL_VALUE_DEFAULT_REPRESENTATION, MAX_STRING_LENGTH);
    public static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("The original FlowFile that was split into segments. If the FlowFile fails processing, nothing will be sent to this relationship").build();
    public static final Relationship REL_SPLIT = new Relationship.Builder().name("split").description("All segments of the original FlowFile will be routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("If a FlowFile fails processing for any reason (for example, the FlowFile is not valid JSON or the specified path does not exist), it will be routed to this relationship").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_ORIGINAL, REL_SPLIT, REL_FAILURE);
    private final AtomicReference<JsonPath> JSON_PATH_REF = new AtomicReference();
    private volatile String nullDefaultValue;
    private volatile Configuration jsonPathConfiguration;

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (descriptor.equals((Object)ARRAY_JSON_PATH_EXPRESSION) && !Strings.CS.equals(oldValue, newValue)) {
            this.JSON_PATH_REF.set(null);
        }
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        AbstractJsonPathProcessor.JsonPathValidator validator = new AbstractJsonPathProcessor.JsonPathValidator(){

            @Override
            public void cacheComputedValue(String subject, String input, JsonPath computedJson) {
                SplitJson.this.JSON_PATH_REF.set(computedJson);
            }

            @Override
            public boolean isStale(String subject, String input) {
                return SplitJson.this.JSON_PATH_REF.get() == null;
            }
        };
        String value = validationContext.getProperty(ARRAY_JSON_PATH_EXPRESSION).getValue();
        return Set.of(validator.validate(ARRAY_JSON_PATH_EXPRESSION.getName(), value, validationContext));
    }

    @OnScheduled
    public void onScheduled(ProcessContext processContext) {
        this.nullDefaultValue = (String)NULL_REPRESENTATION_MAP.get(processContext.getProperty(NULL_VALUE_DEFAULT_REPRESENTATION).getValue());
        int maxStringLength = processContext.getProperty(MAX_STRING_LENGTH).asDataSize(DataUnit.B).intValue();
        this.jsonPathConfiguration = SplitJson.createConfiguration(maxStringLength);
    }

    public void onTrigger(ProcessContext processContext, ProcessSession processSession) {
        Object jsonPathResult;
        DocumentContext documentContext;
        FlowFile original = processSession.get();
        if (original == null) {
            return;
        }
        ComponentLog logger = this.getLogger();
        try {
            documentContext = SplitJson.validateAndEstablishJsonContext(processSession, original, this.jsonPathConfiguration);
        }
        catch (InvalidJsonException e) {
            logger.error("FlowFile {} did not have valid JSON content.", new Object[]{original});
            processSession.transfer(original, REL_FAILURE);
            return;
        }
        JsonPath jsonPath = this.JSON_PATH_REF.get();
        try {
            jsonPathResult = documentContext.read(jsonPath);
        }
        catch (PathNotFoundException e) {
            logger.warn("JsonPath {} could not be found for FlowFile {}", new Object[]{jsonPath.getPath(), original});
            processSession.transfer(original, REL_FAILURE);
            return;
        }
        if (!(jsonPathResult instanceof List)) {
            logger.error("The evaluated value {} of {} was not a JSON Array compatible type and cannot be split.", new Object[]{jsonPathResult, jsonPath.getPath()});
            processSession.transfer(original, REL_FAILURE);
            return;
        }
        List resultList = (List)jsonPathResult;
        HashMap<String, String> attributes = new HashMap<String, String>();
        String fragmentId = UUID.randomUUID().toString();
        attributes.put(FragmentAttributes.FRAGMENT_ID.key(), fragmentId);
        attributes.put(FragmentAttributes.FRAGMENT_COUNT.key(), Integer.toString(resultList.size()));
        for (int i = 0; i < resultList.size(); ++i) {
            Object resultSegment = resultList.get(i);
            FlowFile split = processSession.create(original);
            split = processSession.write(split, out -> {
                String resultSegmentContent = SplitJson.getResultRepresentation(this.jsonPathConfiguration.jsonProvider(), resultSegment, this.nullDefaultValue);
                out.write(resultSegmentContent.getBytes(StandardCharsets.UTF_8));
            });
            attributes.put(FragmentAttributes.SEGMENT_ORIGINAL_FILENAME.key(), split.getAttribute(CoreAttributes.FILENAME.key()));
            attributes.put(FragmentAttributes.FRAGMENT_INDEX.key(), Integer.toString(i));
            processSession.transfer(processSession.putAllAttributes(split, attributes), REL_SPLIT);
        }
        original = FragmentAttributes.copyAttributesToOriginal((ProcessSession)processSession, (FlowFile)original, (String)fragmentId, (int)resultList.size());
        processSession.transfer(original, REL_ORIGINAL);
        logger.info("Split {} into {} FlowFiles", new Object[]{original, resultList.size()});
    }
}

